package com.elitescloud.boot.auth.client.config.security.handler;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCallable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.CollectionUtils;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 认证相关处理.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/14
 */
public class DelegateAuthenticationCallable implements AuthenticationCallable {

    private static DelegateAuthenticationCallable instance;
    private List<AuthenticationCallable> authenticationCallables;

    private DelegateAuthenticationCallable() {
    }

    public static DelegateAuthenticationCallable getInstance() {
        if (instance != null) {
            return instance;
        }
        synchronized (DelegateAuthenticationCallable.class) {
            if (instance == null) {
                instance = new DelegateAuthenticationCallable();
            }
            return instance;
        }
    }

    @Override
    public void onLogin(HttpServletRequest request, HttpServletResponse response, @NotBlank String token, @NotNull Authentication authentication) throws IOException, ServletException {
        if (CollectionUtils.isEmpty(getAuthenticationCallables())) {
            return;
        }

        for (AuthenticationCallable authenticationCallable : getAuthenticationCallables()) {
            authenticationCallable.onLogin(request, response, token, authentication);
        }
    }

    @Override
    public void onLoginFailure(HttpServletRequest request, HttpServletResponse response, @NotNull Authentication authentication, @NotNull AuthenticationException exception) {
        if (CollectionUtils.isEmpty(getAuthenticationCallables())) {
            return;
        }

        for (AuthenticationCallable authenticationCallable : getAuthenticationCallables()) {
            authenticationCallable.onLoginFailure(request, response, authentication, exception);
        }
    }

    @Override
    public void onLogout(HttpServletRequest request, HttpServletResponse response, String token, Object principal) {
        if (CollectionUtils.isEmpty(getAuthenticationCallables())) {
            return;
        }

        for (AuthenticationCallable authenticationCallable : getAuthenticationCallables()) {
            authenticationCallable.onLogout(request, response, token, principal);
        }
    }

    private List<AuthenticationCallable> getAuthenticationCallables() {
        if (authenticationCallables == null) {
            authenticationCallables = SpringContextHolder.getObjectProvider(AuthenticationCallable.class).stream().collect(Collectors.toList());
        }
        return authenticationCallables;
    }
}
