package com.elitescloud.boot.auth.client.config.support;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

import javax.annotation.Nullable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.IOException;

/**
 * 认证成功、认证失败及注销后的回调处理.
 * <p>
 * 所有认证方式认证成功后都要进行的回调处理
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/14
 */
public interface AuthenticationCallable {

    /**
     * 认证成功时的处理
     *
     * @param request        request
     * @param response       response
     * @param token          token信息
     * @param authentication 令牌
     * @throws IOException
     * @throws ServletException
     */
    default void onLogin(HttpServletRequest request, HttpServletResponse response, @NotBlank String token, @NotNull Authentication authentication) throws IOException, ServletException {
    }

    /**
     * 认证失败时的处理
     *
     * @param request   request
     * @param response  response
     * @param authentication  authentication
     * @param exception 认证异常
     */
    default void onLoginFailure(HttpServletRequest request, HttpServletResponse response, @Nullable Authentication authentication, @NotNull AuthenticationException exception) {
    }

    /**
     * 注销时的处理
     *
     * @param request   request
     * @param response  response
     * @param token     token信息
     * @param principal principal
     */
    default void onLogout(HttpServletRequest request, HttpServletResponse response, @Nullable String token, @Nullable Object principal) {
    }
}
