/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.client.config.filter;

import cn.hutool.core.util.BooleanUtil;
import com.elitescloud.boot.auth.client.client.config.OAuthClientProperties;
import com.elitescloud.boot.auth.client.client.service.OAuthClientUserService;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class OAuthClientTokenFilter
extends OncePerRequestFilter {
    private final OAuthClientProperties oauthClientProperties;
    private final OAuthClientUserService userService;
    private final RequestMatcher pathMatcher;

    public OAuthClientTokenFilter(OAuthClientProperties oauthClientProperties, OAuthClientUserService userService) {
        this.oauthClientProperties = oauthClientProperties;
        this.userService = userService;
        this.pathMatcher = new AntPathRequestMatcher(oauthClientProperties.getPath());
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!BooleanUtil.isTrue((Boolean)this.oauthClientProperties.getEnabled())) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (!this.pathMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.userService.grantToken(request, response);
    }
}

