/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.config.security;

import cn.hutool.core.util.BooleanUtil;
import com.elitescloud.boot.auth.client.common.InterceptUri;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.client.config.security.configurer.AuthorizationConfigurerCustomizer;
import com.elitescloud.boot.auth.client.config.security.configurer.DefaultAuthorizationConfigurer;
import com.elitescloud.boot.auth.client.config.security.handler.DefaultAccessDeniedHandler;
import com.elitescloud.boot.auth.client.config.security.handler.DefaultAuthenticationEntryPointHandler;
import com.elitescloud.boot.auth.client.config.security.resolver.BearerTokenResolver;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCache;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.sso.SsoProvider;
import com.elitescloud.boot.auth.sso.configurer.SsoFilterConfigurer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.RememberMeConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.security.web.savedrequest.CookieRequestCache;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

public abstract class AbstractServletSecurityConfig {
    private static final Logger log = LogManager.getLogger(AbstractServletSecurityConfig.class);
    public static final String SECURITY_CHAIN_DEFAULT = "defaultSecurityFilterChain";
    public static final String SECURITY_CHAIN_AUTH2_SERVER = "authorizationServerSecurityFilterChain";
    protected AuthorizationProperties authorizationProperties;
    private AuthorizationSdkProperties authorizationSdkProperties;
    private JwtDecoder jwtDecoder;
    protected ObjectProvider<AuthenticationCache> cacheObjectProvider;
    protected ObjectProvider<SsoProvider> ssoProviderObjectProvider;
    protected ObjectProvider<AuthorizationConfigurerCustomizer> authorizationConfigurerCustomizerObjectProvider;
    protected ObjectProvider<BearerTokenResolver> tokenResolverObjectProvider;

    protected AbstractServletSecurityConfig() {
    }

    protected HttpSecurity defaultSecurityConfig(HttpSecurity http) throws Exception {
        if (Boolean.FALSE.equals(this.authorizationProperties.getCsrfEnabled())) {
            http.csrf().disable();
        }
        this.corsConfiguration(http);
        ((HttpSecurity)((SsoFilterConfigurer)((HttpSecurity)((DefaultAuthorizationConfigurer)http.authorizeRequests(this.authorizeRequest()).apply(new DefaultAuthorizationConfigurer(this.authorizationProperties, (AuthenticationCache)this.cacheObjectProvider.getIfAvailable(), this.jwtDecoder, this.authorizationConfigurerCustomizerObjectProvider))).needBearerTokenAuthenticationFilter(this.needCloudtBearerTokenAuthenticationFilter()).bearerTokenResolver((BearerTokenResolver)this.tokenResolverObjectProvider.getIfAvailable()).autoRenewalToken(this.autoRenewalToken()).and()).apply((SecurityConfigurerAdapter)new SsoFilterConfigurer(this.authorizationSdkProperties))).setSsoProvider((SsoProvider)this.ssoProviderObjectProvider.getIfAvailable()).and()).exceptionHandling(this.exceptionHandlingCustomizer()).sessionManagement(this.sessionManagementCustomizer()).headers(this.headersCustomizer());
        return http;
    }

    protected Customizer<HeadersConfigurer<HttpSecurity>> headersCustomizer() {
        return customizer -> customizer.frameOptions().sameOrigin();
    }

    protected Customizer<SessionManagementConfigurer<HttpSecurity>> sessionManagementCustomizer() {
        if (Boolean.FALSE.equals(this.authorizationProperties.getSessionEnabled())) {
            return customizer -> customizer.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        }
        return customizer -> customizer.sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED);
    }

    protected void corsConfiguration(HttpSecurity http) throws Exception {
        if (Boolean.FALSE.equals(this.authorizationProperties.getCorsEnabled())) {
            http.cors().disable();
            return;
        }
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        for (AuthorizationProperties.CorsConfig cors : this.authorizationProperties.getCors()) {
            CorsConfiguration corsConfiguration = new CorsConfiguration();
            cors.getAllowedOriginPatterns().forEach(arg_0 -> ((CorsConfiguration)corsConfiguration).addAllowedOriginPattern(arg_0));
            cors.getAllowedOrigins().forEach(arg_0 -> ((CorsConfiguration)corsConfiguration).addAllowedOrigin(arg_0));
            cors.getAllowedHeaders().forEach(arg_0 -> ((CorsConfiguration)corsConfiguration).addAllowedHeader(arg_0));
            cors.getExposeHeaders().forEach(arg_0 -> ((CorsConfiguration)corsConfiguration).addExposedHeader(arg_0));
            cors.getAllowedMethods().forEach(arg_0 -> ((CorsConfiguration)corsConfiguration).addAllowedMethod(arg_0));
            corsConfiguration.setAllowCredentials(Boolean.valueOf(cors.isAllowCredentials()));
            source.registerCorsConfiguration(cors.getPathMatcher(), corsConfiguration);
        }
        http.cors(configurer -> configurer.configurationSource((CorsConfigurationSource)source));
    }

    protected Customizer<RememberMeConfigurer<HttpSecurity>> rememberMeConfigurerCustomizer(PersistentTokenRepository tokenRepository, UserDetailsService userDetailsService, AuthenticationSuccessHandler successHandler) {
        int ttl = (int)this.authorizationProperties.getRememberMeTtl().toSeconds();
        if (ttl < 1) {
            return null;
        }
        return customizer -> customizer.rememberMeParameter("remember_me").tokenValiditySeconds(ttl).alwaysRemember(false).tokenRepository(tokenRepository).userDetailsService(userDetailsService).authenticationSuccessHandler(successHandler);
    }

    protected Customizer<ExceptionHandlingConfigurer<HttpSecurity>> exceptionHandlingCustomizer() {
        return configurer -> {
            configurer.authenticationEntryPoint((AuthenticationEntryPoint)new DefaultAuthenticationEntryPointHandler(this.authorizationProperties.getLoginPage()));
            configurer.accessDeniedHandler((AccessDeniedHandler)new DefaultAccessDeniedHandler());
        };
    }

    protected Customizer<ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry> authorizeRequest() {
        return urlRegistry -> {
            if (BooleanUtil.isTrue((Boolean)this.authorizationProperties.getAnonymousEnabled())) {
                log.warn("currently allows anonymous access !");
                Set<String> rejectList = this.getRejectUris();
                if (!rejectList.isEmpty()) {
                    Set antPatterns;
                    Set mvcPatterns = rejectList.stream().filter(this::adapterMvcRequestMatch).collect(Collectors.toSet());
                    if (!mvcPatterns.isEmpty()) {
                        urlRegistry.mvcMatchers((String[])mvcPatterns.toArray(String[]::new)).authenticated();
                    }
                    if (!(antPatterns = rejectList.stream().filter(t -> t != null && !mvcPatterns.contains(t)).collect(Collectors.toSet())).isEmpty()) {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.antMatchers((String[])antPatterns.toArray(String[]::new))).authenticated();
                    }
                }
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.anyRequest()).permitAll();
                return;
            }
            Set<String> allowList = this.getAllowUris();
            if (!allowList.isEmpty()) {
                Set antPatterns;
                Set mvcPatterns = allowList.stream().filter(this::adapterMvcRequestMatch).collect(Collectors.toSet());
                if (!mvcPatterns.isEmpty()) {
                    urlRegistry.mvcMatchers((String[])mvcPatterns.toArray(String[]::new)).permitAll();
                }
                if (!(antPatterns = allowList.stream().filter(t -> t != null && !mvcPatterns.contains(t)).collect(Collectors.toSet())).isEmpty()) {
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.antMatchers((String[])antPatterns.toArray(String[]::new))).permitAll();
                }
            }
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.anyRequest()).authenticated();
        };
    }

    protected boolean adapterMvcRequestMatch(String pattern) {
        return AuthorizationProperties.RequestMatcherType.MVC.equals((Object)this.authorizationProperties.getRequestMatcherType());
    }

    protected Customizer<OAuth2ResourceServerConfigurer<HttpSecurity>> oauth2ResourceServer() {
        return OAuth2ResourceServerConfigurer::jwt;
    }

    protected Set<String> getRejectUris() {
        HashSet<String> rejectList = new HashSet<String>();
        rejectList.addAll(InterceptUri.getRejectUri());
        rejectList.addAll(this.authorizationProperties.getRejectList());
        return rejectList;
    }

    protected Set<String> getAllowUris() {
        HashSet<String> allowList = new HashSet<String>();
        allowList.addAll(InterceptUri.getAllowUri());
        allowList.addAll(this.authorizationProperties.getAllowList());
        if (StringUtils.hasText((String)this.authorizationProperties.getLoginPage())) {
            allowList.add(this.authorizationProperties.getLoginPage());
        }
        return allowList;
    }

    protected boolean needCloudtBearerTokenAuthenticationFilter() {
        return true;
    }

    protected boolean autoRenewalToken() {
        return true;
    }

    public static RequestCache getRequestCache() {
        return new DelegateRequestCache();
    }

    @Autowired
    public void setAuthorizationProperties(AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
    }

    @Autowired
    public void setAuthorizationSdkProperties(AuthorizationSdkProperties authorizationSdkProperties) {
        this.authorizationSdkProperties = authorizationSdkProperties;
    }

    @Autowired
    public void setCacheObjectProvider(ObjectProvider<AuthenticationCache> cacheObjectProvider) {
        this.cacheObjectProvider = cacheObjectProvider;
    }

    @Autowired
    public void setSsoProviderObjectProvider(ObjectProvider<SsoProvider> ssoProviderObjectProvider) {
        this.ssoProviderObjectProvider = ssoProviderObjectProvider;
    }

    @Autowired
    public void setAuthorizationConfigurerCustomizerObjectProvider(ObjectProvider<AuthorizationConfigurerCustomizer> authorizationConfigurerCustomizerObjectProvider) {
        this.authorizationConfigurerCustomizerObjectProvider = authorizationConfigurerCustomizerObjectProvider;
    }

    @Autowired
    public void setJwtDecoder(JwtDecoder jwtDecoder) {
        this.jwtDecoder = jwtDecoder;
    }

    @Autowired
    public void setTokenResolverObjectProvider(ObjectProvider<BearerTokenResolver> tokenResolverObjectProvider) {
        this.tokenResolverObjectProvider = tokenResolverObjectProvider;
    }

    static class DelegateRequestCache
    implements RequestCache {
        private final List<RequestCache> requestCaches = new ArrayList<RequestCache>();

        public DelegateRequestCache() {
            this.requestCaches.add((RequestCache)new HttpSessionRequestCache());
            this.requestCaches.add((RequestCache)new CookieRequestCache());
        }

        public void saveRequest(HttpServletRequest request, HttpServletResponse response) {
            for (RequestCache cache : this.requestCaches) {
                cache.saveRequest(request, response);
            }
        }

        public SavedRequest getRequest(HttpServletRequest request, HttpServletResponse response) {
            for (RequestCache cache : this.requestCaches) {
                SavedRequest req = cache.getRequest(request, response);
                if (req == null) continue;
                return req;
            }
            return null;
        }

        public HttpServletRequest getMatchingRequest(HttpServletRequest request, HttpServletResponse response) {
            for (RequestCache cache : this.requestCaches) {
                HttpServletRequest req = cache.getMatchingRequest(request, response);
                if (req == null) continue;
                return req;
            }
            return null;
        }

        public void removeRequest(HttpServletRequest request, HttpServletResponse response) {
            for (RequestCache cache : this.requestCaches) {
                cache.removeRequest(request, response);
            }
        }
    }
}

