/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.config.security.handler;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCallable;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.CollectionUtils;

public class DelegateAuthenticationCallable
implements AuthenticationCallable {
    private static DelegateAuthenticationCallable instance;
    private List<AuthenticationCallable> authenticationCallables;

    private DelegateAuthenticationCallable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DelegateAuthenticationCallable getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<DelegateAuthenticationCallable> clazz = DelegateAuthenticationCallable.class;
        synchronized (DelegateAuthenticationCallable.class) {
            if (instance == null) {
                instance = new DelegateAuthenticationCallable();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void onLogin(HttpServletRequest request, HttpServletResponse response, @NotBlank String token, @NotNull Authentication authentication) throws IOException, ServletException {
        if (CollectionUtils.isEmpty(this.getAuthenticationCallables())) {
            return;
        }
        for (AuthenticationCallable authenticationCallable : this.getAuthenticationCallables()) {
            authenticationCallable.onLogin(request, response, token, authentication);
        }
    }

    @Override
    public void onLoginFailure(HttpServletRequest request, HttpServletResponse response, @NotNull Authentication authentication, @NotNull AuthenticationException exception) {
        if (CollectionUtils.isEmpty(this.getAuthenticationCallables())) {
            return;
        }
        for (AuthenticationCallable authenticationCallable : this.getAuthenticationCallables()) {
            authenticationCallable.onLoginFailure(request, response, authentication, exception);
        }
    }

    @Override
    public void onLogout(HttpServletRequest request, HttpServletResponse response, String token, Object principal) {
        if (CollectionUtils.isEmpty(this.getAuthenticationCallables())) {
            return;
        }
        for (AuthenticationCallable authenticationCallable : this.getAuthenticationCallables()) {
            authenticationCallable.onLogout(request, response, token, principal);
        }
    }

    private List<AuthenticationCallable> getAuthenticationCallables() {
        if (this.authenticationCallables == null) {
            this.authenticationCallables = SpringContextHolder.getObjectProvider(AuthenticationCallable.class).stream().collect(Collectors.toList());
        }
        return this.authenticationCallables;
    }
}

