/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.lang.NonNull;

public class InterceptUri {
    private static final Set<String> ALLOW_URI = new HashSet<String>();
    private static final Set<String> REJECT_URI = new HashSet<String>();

    private InterceptUri() {
    }

    public static void addAllowUri(@NonNull Set<String> allowUri) {
        ALLOW_URI.addAll(allowUri);
    }

    public static void addRejectUri(@NonNull Set<String> rejectUri) {
        REJECT_URI.addAll(rejectUri);
    }

    public static Set<String> getAllowUri() {
        return Collections.unmodifiableSet(ALLOW_URI);
    }

    public static Set<String> getRejectUri() {
        return Collections.unmodifiableSet(REJECT_URI);
    }

    static {
        ALLOW_URI.add("/oauth2/**");
        ALLOW_URI.add("/oauth/**");
        ALLOW_URI.add("/oauth/sso/**");
        ALLOW_URI.add("/login.html");
        ALLOW_URI.add("/rpc/**");
        ALLOW_URI.add("/actuator/**");
        ALLOW_URI.add("/cloudt/core/ext/ready");
        ALLOW_URI.add("/com/file/v1/*/download");
        ALLOW_URI.add("/com/file/v1/*/show");
        ALLOW_URI.add("/com/file/v1/download/package");
        ALLOW_URI.add("/com/file/v1/package/**");
        ALLOW_URI.add("/doc.html");
        ALLOW_URI.add("/doc/index.html");
        ALLOW_URI.add("/webjars/**");
        ALLOW_URI.add("/swagger-resources");
        ALLOW_URI.add("/*/api-docs");
        ALLOW_URI.add("/**/*.css");
        ALLOW_URI.add("/**/*.js");
        ALLOW_URI.add("/**/*.svg");
        ALLOW_URI.add("/**/*.ttf");
        ALLOW_URI.add("/**/*.woff");
        ALLOW_URI.add("/**/*.woff2");
        ALLOW_URI.add("/**/*.ico");
    }
}

