/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.config.security;

import com.elitescloud.boot.auth.client.config.security.AbstractServletSecurityConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.SecurityFilterChain;

@ConditionalOnProperty(prefix="elitesland.authorization", name={"type"}, havingValue="oauth2_resource")
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class OAuth2ResourceServletSecurityConfig
extends AbstractServletSecurityConfig {
    private static final Logger log = LogManager.getLogger(OAuth2ResourceServletSecurityConfig.class);

    @Bean(value={"defaultSecurityFilterChain"})
    @ConditionalOnMissingBean(name={"defaultSecurityFilterChain"})
    public SecurityFilterChain defaultSecurityFilterChain(HttpSecurity http) throws Exception {
        super.defaultSecurityConfig(http);
        http.oauth2ResourceServer(super.oauth2ResourceServer());
        return (SecurityFilterChain)http.build();
    }
}

