/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.util;

import com.elitescloud.boot.auth.client.common.CodeChallengeMethod;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.NonNull;

public class ProofKeyUtil {
    private static final Map<CodeChallengeMethod, MessageDigest> DIGEST_MAP = new HashMap<CodeChallengeMethod, MessageDigest>();

    private ProofKeyUtil() {
    }

    @NonNull
    public static String codeChallenge(@NonNull CodeChallengeMethod codeChallengeMethod, @NonNull String codeVerifier) throws Exception {
        MessageDigest digest = DIGEST_MAP.computeIfAbsent(codeChallengeMethod, k -> {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        });
        byte[] bytes = digest.digest(codeVerifier.getBytes(StandardCharsets.US_ASCII));
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }
}

