/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.util;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.AuthorizedClient;
import com.elitescloud.boot.auth.BearerTokenAuthenticationToken;
import com.elitescloud.boot.auth.CommonAuthenticationToken;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCache;
import com.elitescloud.boot.auth.client.config.support.AuthenticationContext;
import com.elitescloud.boot.auth.util.SecurityUtil;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SecurityContextUtil {
    private static final Logger log = LogManager.getLogger(SecurityContextUtil.class);
    private static final ContextBeanHolder CONTEXT_BEAN_HOLDER = new ContextBeanHolder();

    protected SecurityContextUtil() {
    }

    @Nullable
    public static Long currentUserId() {
        Long userId = (Long)SecurityContextUtil.currentUserClaims().get("yst_ui");
        if (userId != null) {
            return userId;
        }
        return SecurityContextUtil.currentAuthenticationProperty(AuthenticationContext::getUserId);
    }

    @Nullable
    public static String currentUserName() {
        String username = (String)SecurityContextUtil.currentUserClaims().get("yst_un");
        if (StringUtils.hasText((String)username)) {
            return username;
        }
        return SecurityContextUtil.currentAuthenticationProperty(AuthenticationContext::getUsername);
    }

    @Nullable
    public static Long currentTenantId() {
        Long tenantId = (Long)SecurityContextUtil.currentUserClaims().get("yst_ti");
        if (tenantId != null) {
            return tenantId;
        }
        return SecurityContextUtil.currentAuthenticationProperty(AuthenticationContext::getTenantId);
    }

    @Nullable
    public static GeneralUserDetails currentUser() {
        return SecurityContextUtil.currentUser(false);
    }

    @NonNull
    public static GeneralUserDetails currentUserIfUnauthorizedThrow() {
        return Objects.requireNonNull(SecurityContextUtil.currentUser(true));
    }

    @Nullable
    public static String currentToken() {
        Jwt jwt = SecurityContextUtil.currentAuthenticationJwt();
        if (jwt == null) {
            return null;
        }
        return jwt.getTokenValue();
    }

    public static void updateCurrentUser(@NonNull GeneralUserDetails user) {
        Assert.notNull((Object)user, (String)"\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        Jwt jwt = SecurityContextUtil.currentAuthenticationJwt();
        if (jwt == null) {
            SecurityUtil.throwUnauthorizedException();
            return;
        }
        user.setExtendInfo(null);
        Duration ttl = null;
        if (jwt.getExpiresAt() != null) {
            ttl = Duration.between(LocalDateTime.now(), jwt.getExpiresAt().atOffset(DatetimeUtil.SYS_ZONE_OFFSET));
        }
        CONTEXT_BEAN_HOLDER.getAuthenticationCache().setUserDetail(jwt.getTokenValue(), user, ttl);
    }

    public static GeneralUserDetails convertToken(String token) {
        return CONTEXT_BEAN_HOLDER.getAuthenticationCache().getUserDetail(token);
    }

    public static AuthorizedClient currentAuthorizedClient() {
        return SecurityContextUtil.currentAuthorizedClient(false);
    }

    public static AuthorizedClient currentAuthorizedClientIfUnauthorizedThrow() {
        return SecurityContextUtil.currentAuthorizedClient(true);
    }

    private static GeneralUserDetails currentUser(boolean required) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || authentication instanceof AnonymousAuthenticationToken) {
            if (required) {
                SecurityUtil.throwUnauthorizedException();
            }
            return null;
        }
        if (authentication instanceof CommonAuthenticationToken) {
            GeneralUserDetails user = ((CommonAuthenticationToken)authentication).getUserDetails();
            if (required && user == null) {
                SecurityUtil.throwUnauthorizedException();
            }
            return user;
        }
        if (authentication instanceof BearerTokenAuthenticationToken && authentication.getPrincipal() instanceof GeneralUserDetails) {
            GeneralUserDetails user = (GeneralUserDetails)authentication.getPrincipal();
            if (required && user == null) {
                SecurityUtil.throwUnauthorizedException();
            }
        }
        GeneralUserDetails userDetails = null;
        AuthorizedClient authorizedClient = null;
        Jwt jwt = SecurityContextUtil.currentAuthenticationJwt(authentication);
        if (jwt != null) {
            userDetails = SecurityContextUtil.convertToken(jwt.getTokenValue());
            authorizedClient = AuthorizedClient.buildByJwt((Jwt)jwt);
            CommonAuthenticationToken authenticationToken = new CommonAuthenticationToken(authentication, userDetails, authentication.getAuthorities());
            authenticationToken.setAuthorizedClient(authorizedClient);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
        }
        if (userDetails == null) {
            log.debug("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0ctoken\u4e0d\u5b58\u5728\u6216\u5df2\u8fc7\u671f");
            if (required) {
                SecurityUtil.throwUnauthorizedException();
            }
            return null;
        }
        return userDetails;
    }

    private static AuthorizedClient currentAuthorizedClient(boolean required) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || authentication instanceof AnonymousAuthenticationToken) {
            if (required) {
                SecurityUtil.throwUnauthorizedException();
            }
            return null;
        }
        if (authentication instanceof CommonAuthenticationToken) {
            AuthorizedClient client = ((CommonAuthenticationToken)authentication).getAuthorizedClient();
            if (required && client == null) {
                SecurityUtil.throwUnauthorizedException();
            }
            return client;
        }
        if (authentication instanceof BearerTokenAuthenticationToken) {
            AuthorizedClient client = ((BearerTokenAuthenticationToken)authentication).getAuthorizedClient();
            if (required && client == null) {
                SecurityUtil.throwUnauthorizedException();
            }
            return client;
        }
        GeneralUserDetails userDetails = null;
        AuthorizedClient authorizedClient = null;
        Jwt jwt = SecurityContextUtil.currentAuthenticationJwt(authentication);
        if (jwt != null) {
            userDetails = SecurityContextUtil.convertToken(jwt.getTokenValue());
            authorizedClient = AuthorizedClient.buildByJwt((Jwt)jwt);
            CommonAuthenticationToken authenticationToken = new CommonAuthenticationToken(authentication, userDetails, authentication.getAuthorities());
            authenticationToken.setAuthorizedClient(authorizedClient);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
        }
        if (required && authorizedClient == null) {
            SecurityUtil.throwUnauthorizedException();
        }
        return authorizedClient;
    }

    private static Map<String, Object> currentUserClaims() {
        Jwt jwt = SecurityContextUtil.currentAuthenticationJwt();
        if (jwt == null) {
            return Collections.emptyMap();
        }
        return jwt.getClaims();
    }

    private static Jwt currentAuthenticationJwt() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || authentication instanceof AnonymousAuthenticationToken) {
            return null;
        }
        if (authentication instanceof CommonAuthenticationToken) {
            CommonAuthenticationToken authenticationToken = (CommonAuthenticationToken)authentication;
            return SecurityContextUtil.currentAuthenticationJwt(authenticationToken.getOriginal());
        }
        return SecurityContextUtil.currentAuthenticationJwt(authentication);
    }

    private static Jwt currentAuthenticationJwt(Authentication authentication) {
        if (authentication == null || authentication instanceof AnonymousAuthenticationToken) {
            return null;
        }
        if (authentication instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthenticationToken = (JwtAuthenticationToken)authentication;
            return (Jwt)jwtAuthenticationToken.getToken();
        }
        if (authentication instanceof BearerTokenAuthenticationToken) {
            BearerTokenAuthenticationToken bearerTokenAuthenticationToken = (BearerTokenAuthenticationToken)authentication;
            String token = bearerTokenAuthenticationToken.getToken();
            return CONTEXT_BEAN_HOLDER.getJwtDecoder().decode(token);
        }
        log.debug("\u6682\u4e0d\u652f\u6301\u7684Authentication\u7c7b\u578b\uff1a{}", (Object)authentication.getClass().getName());
        return null;
    }

    private static <T> T currentAuthenticationProperty(Function<AuthenticationContext, T> apply) {
        Iterator<AuthenticationContext> contextIterator = CONTEXT_BEAN_HOLDER.getAuthenticationContext();
        while (contextIterator.hasNext()) {
            T value = apply.apply(contextIterator.next());
            if (value == null) continue;
            return value;
        }
        return null;
    }

    static class ContextBeanHolder {
        private final Map<Class<?>, ObjectProvider<Object>> sharedBeans = new HashMap();

        ContextBeanHolder() {
        }

        public JwtDecoder getJwtDecoder() {
            return (JwtDecoder)this.getSharedBean(JwtDecoder.class).getIfAvailable();
        }

        public AuthenticationCache getAuthenticationCache() {
            return (AuthenticationCache)this.getSharedBean(AuthenticationCache.class).getIfAvailable();
        }

        public Iterator<AuthenticationContext> getAuthenticationContext() {
            return this.getSharedBean(AuthenticationContext.class).iterator();
        }

        private <T> ObjectProvider<T> getSharedBean(Class<T> clazz) {
            ObjectProvider objectProvider = this.sharedBeans.get(clazz);
            if (objectProvider != null) {
                return objectProvider;
            }
            objectProvider = SpringContextHolder.getObjectProvider(clazz);
            if (objectProvider != null) {
                this.sharedBeans.put(clazz, (ObjectProvider<Object>)objectProvider);
            }
            return objectProvider;
        }
    }
}

