package com.elitescloud.boot.auth.client.config.support;

import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

import java.time.Duration;

/**
 * Authentication缓存.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/1
 */
public interface AuthenticationCache {

    /**
     * 缓存用户信息
     *
     * @param key        缓存key
     * @param user       用户信息
     * @param timeToLive 缓存时间
     */
    void setUserDetail(@NonNull String key, @NonNull GeneralUserDetails user, Duration timeToLive);

    /**
     * 从缓存获取用户信息
     *
     * @param key 缓存key
     * @return 用户信息
     */
    @Nullable
    GeneralUserDetails getUserDetail(@NonNull String key);

    /**
     * 移除缓存中用户信息
     *
     * @param key 缓存key
     */
    void removeUserDetail(@NonNull String key);

    /**
     * 设置有效时间
     *
     * @param key key
     * @param ttl 有效存活时间，为空则直接过期
     */
    void expireAt(@NonNull String key, Duration ttl);

    /**
     * 判断缓存是否存在
     *
     * @param key 缓存key
     * @return true/false
     */
    boolean exists(@NonNull String key);

    /**
     * 缓存属性
     *
     * @param key        缓存key
     * @param attribute  属性
     * @param timeToLive 缓存时间
     */
    void setAttribute(@NonNull String key, @NonNull Object attribute, Duration timeToLive);

    /**
     * 获取缓存属性
     *
     * @param key 缓存key
     * @return 属性
     */
    Object getAttribute(@NonNull String key);

    /**
     * 移除缓存属性
     *
     * @param key 缓存key
     */
    void removeAttribute(@NonNull String key);

    /**
     * 设置有效时间
     *
     * @param key key
     * @param ttl 有效存活时间，为空则直接过期
     */
    void expireAttributeAt(@NonNull String key, Duration ttl);

    /**
     * 缓存属性是否存在
     *
     * @param key 缓存key
     * @return true/false
     */
    boolean existsAttribute(@NonNull String key);
}
