/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.config;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.CloudtSecurityDefaultAutoConfiguration;
import com.elitescloud.boot.auth.AuthorizedClient;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCache;
import com.elitescloud.boot.auth.client.config.support.RedisAuthenticationCache;
import com.elitescloud.boot.auth.client.tool.RedisHelper;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.provider.CurrentUserProvider;
import com.elitescloud.boot.provider.UserDetailProvider;
import com.elitescloud.boot.redis.CloudtRedisAutoConfiguration;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.wrapper.BaseCallbackWrapper;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import javax.validation.constraints.NotBlank;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfigureAfter(value={CloudtRedisAutoConfiguration.class})
@AutoConfigureBefore(value={CloudtSecurityDefaultAutoConfiguration.class})
@ConditionalOnBean(value={RedisUtils.class})
public class CloudtAuthorizationCacheAutoConfiguration {
    private final RedisUtils redisUtils;

    public CloudtAuthorizationCacheAutoConfiguration(RedisUtils redisUtils) {
        this.redisUtils = redisUtils;
    }

    @Bean
    @ConditionalOnMissingBean
    RedisHelper redisHelper(ObjectProvider<RedisWrapper> wrapperObjectProvider) {
        return new RedisHelper(this.redisUtils, (BaseCallbackWrapper)wrapperObjectProvider.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean
    AuthenticationCache defaultAuthenticationCache(RedisHelper redisHelper) {
        return new RedisAuthenticationCache(redisHelper);
    }

    @Bean
    UserDetailProvider userDetailProvider() {
        return new UserDetailProvider(){

            public GeneralUserDetails getByToken(@NotBlank String token) {
                if (CharSequenceUtil.isBlank((CharSequence)token)) {
                    return null;
                }
                String[] tokenArray = token.split(" ");
                token = tokenArray.length == 1 ? tokenArray[0] : tokenArray[1];
                return SecurityContextUtil.convertToken(token);
            }

            public GeneralUserDetails currentUser() {
                return SecurityContextUtil.currentUser();
            }
        };
    }

    @Bean
    CurrentUserProvider currentUserProvider() {
        return new CurrentUserProvider(){

            public SysUserDTO currentUser() {
                GeneralUserDetails user = SecurityContextUtil.currentUser();
                return user == null ? null : user.getUser();
            }

            public AuthorizedClient currentClient() {
                return SecurityContextUtil.currentAuthorizedClient();
            }
        };
    }
}

