/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.config.security.handler;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.util.ObjectMapperFactory;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public abstract class AbstractHandler {
    private static final Logger log = LogManager.getLogger(AbstractHandler.class);
    protected final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private ObjectMapper objectMapper;

    protected void writeResponse(@NonNull HttpServletResponse response, @NonNull Object result) throws IOException {
        this.writeResponse(response, result, HttpStatus.OK);
    }

    protected void writeResponse(@NonNull HttpServletResponse response, @NonNull Object result, HttpStatus httpStatus) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType("application/json");
        response.setStatus(httpStatus == null ? HttpStatus.OK.value() : httpStatus.value());
        String content = null;
        try {
            content = result instanceof String ? (String)result : this.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(result);
        }
        catch (JsonProcessingException e) {
            log.error("\u8fd4\u56deresponse\u5f02\u5e38\uff1a", (Throwable)e);
            content = ((Throwable)ObjectUtil.defaultIfNull((Object)e.getCause(), (Object)((Object)e))).getMessage();
        }
        try (PrintWriter writer = response.getWriter();){
            writer.write(content);
        }
        catch (IOException e) {
            log.error("\u8fd4\u56de\u7ed3\u679c\u5931\u8d25\uff1a", (Throwable)e);
            throw e;
        }
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        this.redirectStrategy.sendRedirect(request, response, url);
    }

    protected void sendRedirect(String uriPrefix, DefaultSavedRequest savedRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!StringUtils.hasText((String)uriPrefix)) {
            this.sendRedirect(request, response, savedRequest.getRedirectUrl());
            return;
        }
        String url = this.obtainRedirectUrl(uriPrefix, savedRequest);
        this.sendRedirect(request, response, url);
    }

    protected String obtainRedirectUrl(String uriPrefix, DefaultSavedRequest savedRequest) {
        if (!StringUtils.hasText((String)uriPrefix)) {
            return savedRequest.getRedirectUrl();
        }
        if (uriPrefix.endsWith("/")) {
            uriPrefix = uriPrefix.substring(0, uriPrefix.length() - 1);
        }
        String queryString = StringUtils.hasText((String)savedRequest.getQueryString()) ? "?" + savedRequest.getQueryString() : "";
        return uriPrefix + savedRequest.getRequestURI() + queryString;
    }

    protected boolean supportRedirect(HttpServletRequest request) {
        String redirect = request.getHeader("X-Auth-Redirect");
        return redirect == null || "true".equalsIgnoreCase(redirect);
    }

    protected boolean supportRedirect(SavedRequest request) {
        List redirect = request.getHeaderValues("X-Auth-Redirect");
        if (CollectionUtils.isEmpty((Collection)redirect)) {
            return true;
        }
        for (String s : redirect) {
            if (!"true".equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    protected void printParameters(HttpServletRequest request) {
        MultiValueMap parametersQuery = HttpServletUtil.getQueryParameters((HttpServletRequest)request);
        log.info("\u67e5\u8be2\u53c2\u6570\uff1a{}", new Supplier[]{() -> {
            try {
                return this.getObjectMapper().writeValueAsString((Object)parametersQuery);
            }
            catch (JsonProcessingException e) {
                log.error(request.getRequestURI() + "\u6253\u5370\u53c2\u6570\u5f02\u5e38\uff1a", (Throwable)e);
                return "";
            }
        }});
        MultiValueMap parametersForm = HttpServletUtil.getFormParameters((HttpServletRequest)request);
        log.info("\u8868\u5355\u53c2\u6570\uff1a{}", new Supplier[]{() -> {
            try {
                return this.getObjectMapper().writeValueAsString((Object)parametersForm);
            }
            catch (JsonProcessingException e) {
                log.error(request.getRequestURI() + "\u6253\u5370\u53c2\u6570\u5f02\u5e38\uff1a", (Throwable)e);
                return "";
            }
        }});
    }

    protected void printHeaders(HttpServletRequest request) {
        MultiValueMap headers = HttpServletUtil.getHeaders((HttpServletRequest)request);
        log.info("\u8bf7\u6c42\u5934\uff1a{}", new Supplier[]{() -> {
            try {
                return this.getObjectMapper().writeValueAsString((Object)headers);
            }
            catch (JsonProcessingException e) {
                log.error(request.getRequestURI() + "\u6253\u5370\u8bf7\u6c42\u5934\u5f02\u5e38\uff1a", (Throwable)e);
                return "";
            }
        }});
    }

    protected Map<String, String[]> getParameterMap(DefaultSavedRequest request) {
        HashMap<String, String[]> parameterMap = request.getParameterMap();
        if (CollUtil.isNotEmpty((Map)parameterMap)) {
            return parameterMap;
        }
        String queryStr = request.getQueryString();
        parameterMap = new HashMap<String, String[]>(32);
        if (StringUtils.hasText((String)queryStr)) {
            for (String s : queryStr.split("&")) {
                String v;
                String[] ps = s.split("=");
                String k = ps[0];
                String string = v = ps.length > 1 ? ps[1] : "";
                if (parameterMap.containsKey(k)) {
                    parameterMap.put(k, (String[])ArrayUtil.append((Object[])((String[])parameterMap.get(k)), (Object[])new String[]{v}));
                    continue;
                }
                parameterMap.put(k, new String[]{v});
            }
        }
        return parameterMap;
    }

    protected String getParameter(DefaultSavedRequest request, String parameterName) {
        Map<String, String[]> parameterMap = this.getParameterMap(request);
        String[] values = parameterMap.get(parameterName);
        return values != null && values.length > 0 ? values[0] : null;
    }

    protected String getUrlPrefix(HttpServletRequest request, AuthorizationProperties authorizationProperties) {
        String urlPrefix = request.getParameter("authSvr");
        if (StringUtils.hasText((String)urlPrefix)) {
            return urlPrefix;
        }
        urlPrefix = authorizationProperties.getRedirectUriPrefix();
        if (StringUtils.hasText((String)urlPrefix)) {
            return urlPrefix;
        }
        urlPrefix = request.getHeader("Referer");
        if (StringUtils.hasText((String)urlPrefix)) {
            String urlPath = URI.create(urlPrefix).getPath();
            return StringUtils.hasText((String)urlPath) ? urlPrefix.substring(0, urlPrefix.indexOf(urlPath)) : urlPrefix;
        }
        urlPrefix = request.getRequestURL().toString();
        return StringUtils.hasText((String)request.getRequestURI()) ? urlPrefix.substring(0, urlPrefix.indexOf(request.getRequestURI())) : urlPrefix;
    }

    protected String getUrlPrefix(DefaultSavedRequest savedRequest, AuthorizationProperties authorizationProperties) {
        String urlPrefix = this.getFirstParam(savedRequest, "authSvr");
        if (StringUtils.hasText((String)urlPrefix)) {
            return urlPrefix;
        }
        urlPrefix = authorizationProperties.getRedirectUriPrefix();
        if (StringUtils.hasText((String)urlPrefix)) {
            return urlPrefix;
        }
        urlPrefix = this.getFirstHeader(savedRequest, "Referer");
        if (StringUtils.hasText((String)urlPrefix)) {
            String urlPath = URI.create(urlPrefix).getPath();
            return StringUtils.hasText((String)urlPath) ? urlPrefix.substring(0, urlPrefix.indexOf(urlPath)) : urlPrefix;
        }
        urlPrefix = savedRequest.getRequestURL();
        return StringUtils.hasText((String)savedRequest.getRequestURI()) ? urlPrefix.substring(0, urlPrefix.indexOf(savedRequest.getRequestURI())) : urlPrefix;
    }

    private String getFirstParam(DefaultSavedRequest savedRequest, String paramName) {
        Object[] params = savedRequest.getParameterValues(paramName);
        return ArrayUtil.isEmpty((Object[])params) ? null : params[0];
    }

    private String getFirstHeader(DefaultSavedRequest savedRequest, String headerName) {
        List params = savedRequest.getHeaderValues(headerName);
        return CollUtil.isEmpty((Collection)params) ? null : (String)params.get(0);
    }

    protected ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            try {
                this.objectMapper = (ObjectMapper)SpringContextHolder.getBean(ObjectMapper.class);
            }
            catch (Exception e) {
                log.warn("\u83b7\u53d6ObjectMapper\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                this.objectMapper = ObjectMapperFactory.instance();
            }
        }
        return this.objectMapper;
    }
}

