/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.config.support;

import com.elitescloud.boot.auth.client.config.support.AuthenticationCache;
import com.elitescloud.boot.auth.client.tool.RedisHelper;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;

public class RedisAuthenticationCache
implements AuthenticationCache {
    private static final Logger log = LogManager.getLogger(RedisAuthenticationCache.class);
    private final RedisHelper redisHelper;

    public RedisAuthenticationCache(RedisHelper redisHelper) {
        this.redisHelper = redisHelper;
    }

    @Override
    public void setUserDetail(@NonNull String key, @NonNull GeneralUserDetails user, Duration timeToLive) {
        try {
            this.redisHelper.execute(redisUtils -> {
                String cacheKey = this.generateCacheKey(key);
                if (timeToLive != null) {
                    redisUtils.set(cacheKey, (Object)user, timeToLive.toSeconds());
                    return null;
                }
                redisUtils.set(cacheKey, (Object)user);
                return null;
            });
        }
        catch (Exception e) {
            throw new BusinessException("\u7f13\u5b58\u7528\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public GeneralUserDetails getUserDetail(@NonNull String key) {
        try {
            return this.redisHelper.execute(redisUtils -> {
                String cacheKey = this.generateCacheKey(key);
                return (GeneralUserDetails)redisUtils.get(cacheKey);
            });
        }
        catch (Exception e) {
            throw new BusinessException("\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void removeUserDetail(@NonNull String key) {
        try {
            this.redisHelper.execute(redisUtils -> {
                String cacheKey = this.generateCacheKey(key);
                redisUtils.del(new String[]{cacheKey});
                return null;
            });
        }
        catch (Exception e) {
            throw new BusinessException("\u5220\u9664\u7528\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void expireAt(@NonNull String key, Duration ttl) {
        try {
            this.redisHelper.execute(redisUtils -> {
                String cacheKey = this.generateCacheKey(key);
                if (ttl == null) {
                    redisUtils.del(new String[]{cacheKey});
                    return null;
                }
                redisUtils.expire(cacheKey, ttl.toSeconds(), TimeUnit.SECONDS);
                return null;
            });
        }
        catch (Exception e) {
            throw new BusinessException("\u8bbe\u7f6e\u7528\u6237\u8fc7\u671f\u65f6\u95f4\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public boolean exists(@NonNull String key) {
        try {
            return this.redisHelper.execute(redisUtils -> {
                String cacheKey = this.generateCacheKey(key);
                return redisUtils.hasKey(cacheKey);
            });
        }
        catch (Exception e) {
            throw new BusinessException("\u5224\u65ad\u7528\u6237\u7f13\u5b58\u662f\u5426\u5b58\u5728\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void setAttribute(@NonNull String key, @NonNull Object attribute, Duration timeToLive) {
        try {
            this.redisHelper.execute(redisUtils -> {
                String cacheKey = this.generateAttributeCacheKey(key);
                if (timeToLive != null) {
                    redisUtils.set(cacheKey, attribute, timeToLive.toSeconds());
                    return null;
                }
                redisUtils.set(cacheKey, attribute);
                return null;
            });
        }
        catch (Exception e) {
            throw new BusinessException("\u7f13\u5b58\u7528\u6237\u6269\u5c55\u5c5e\u6027\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public Object getAttribute(@NonNull String key) {
        try {
            return this.redisHelper.execute(redisUtils -> {
                String cacheKey = this.generateAttributeCacheKey(key);
                return redisUtils.get(cacheKey);
            });
        }
        catch (Exception e) {
            throw new BusinessException("\u83b7\u53d6\u7528\u6237\u5c5e\u6027\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void removeAttribute(@NonNull String key) {
        try {
            this.redisHelper.execute(redisUtils -> {
                String cacheKey = this.generateAttributeCacheKey(key);
                redisUtils.del(new String[]{cacheKey});
                return null;
            });
        }
        catch (Exception e) {
            throw new BusinessException("\u5220\u9664\u7528\u6237\u5c5e\u6027\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void expireAttributeAt(@NonNull String key, Duration ttl) {
        try {
            this.redisHelper.execute(redisUtils -> {
                String cacheKey = this.generateAttributeCacheKey(key);
                if (ttl == null) {
                    redisUtils.del(new String[]{cacheKey});
                    return null;
                }
                redisUtils.expire(cacheKey, ttl.toSeconds(), TimeUnit.SECONDS);
                return null;
            });
        }
        catch (Exception e) {
            throw new BusinessException("\u8bbe\u7f6e\u7528\u6237\u8fc7\u671f\u65f6\u95f4\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public boolean existsAttribute(@NonNull String key) {
        try {
            return this.redisHelper.execute(redisUtils -> {
                String cacheKey = this.generateAttributeCacheKey(key);
                return redisUtils.hasKey(cacheKey);
            });
        }
        catch (Exception e) {
            throw new BusinessException("\u5224\u65ad\u7528\u6237\u7f13\u5b58\u662f\u5426\u5b58\u5728\u5931\u8d25", (Throwable)e);
        }
    }

    private String generateCacheKey(String cacheKey) {
        return "cloudt:current_user:" + cacheKey;
    }

    private String generateAttributeCacheKey(String cacheKey) {
        return "cloudt:current_user_attr:" + cacheKey;
    }
}

