/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.data.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;

public class JsqlParserUtil {
    private static final Cache<String, Statement> singleStatementCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(Duration.ofMinutes(10L)).build();
    private static final Cache<String, Statements> multiStatementCache = Caffeine.newBuilder().maximumSize(500L).expireAfterWrite(Duration.ofMinutes(10L)).build();

    public static Statement parse(@NotBlank String sql) throws JSQLParserException {
        Statement statement = (Statement)singleStatementCache.getIfPresent((Object)sql);
        if (statement == null) {
            statement = CCJSqlParserUtil.parse((String)sql);
            singleStatementCache.put((Object)sql, (Object)statement);
        }
        return statement;
    }

    public static Statements parseStatements(@NotBlank String sql) throws JSQLParserException {
        Statements statements = (Statements)multiStatementCache.getIfPresent((Object)sql);
        if (statements == null) {
            statements = CCJSqlParserUtil.parseStatements((String)sql);
            multiStatementCache.put((Object)sql, (Object)statements);
        }
        return statements;
    }

    public static boolean existsColumnOfWhere(@NotBlank String sql, @NotNull Predicate<Column> columnPredicate) throws JSQLParserException {
        Statement statement = JsqlParserUtil.parse(sql);
        return JsqlParserUtil.existsColumnOfWhere(statement, columnPredicate);
    }

    public static boolean existsColumnOfWhere(@NotNull Statement statement, @NotBlank Predicate<Column> columnPredicate) {
        if (statement instanceof Select) {
            return JsqlParserUtil.existsColumn(((PlainSelect)((Select)statement).getSelectBody()).getWhere(), columnPredicate);
        }
        if (statement instanceof Update) {
            return JsqlParserUtil.existsColumn(((Update)statement).getWhere(), columnPredicate);
        }
        if (statement instanceof Delete) {
            return JsqlParserUtil.existsColumn(((Delete)statement).getWhere(), columnPredicate);
        }
        return false;
    }

    private static boolean existsColumn(Expression expression, final Predicate<Column> columnPredicate) {
        if (expression == null) {
            return false;
        }
        final AtomicBoolean found = new AtomicBoolean(false);
        expression.accept((ExpressionVisitor)new ExpressionDeParser(){

            public void visit(Column columnExpression) {
                if (columnPredicate.test(columnExpression)) {
                    found.set(true);
                }
            }
        });
        return found.get();
    }
}

