/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.data.support.id.util;

import com.elitescloud.boot.data.support.id.config.IdProperties;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.JdbcProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class IdTool {
    private IdTool() {
    }

    public static JdbcTemplate buildJdbcTemplate(@NonNull Environment environment, DataSource defaultDatasource, @NonNull IdProperties idProperties, @NonNull JdbcProperties properties) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(IdTool.loadDatasource(environment, defaultDatasource, idProperties));
        JdbcProperties.Template template = properties.getTemplate();
        jdbcTemplate.setFetchSize(template.getFetchSize());
        jdbcTemplate.setMaxRows(template.getMaxRows());
        if (template.getQueryTimeout() != null) {
            jdbcTemplate.setQueryTimeout((int)template.getQueryTimeout().getSeconds());
        }
        return jdbcTemplate;
    }

    private static DataSource loadDatasource(Environment environment, DataSource defaultDatasource, IdProperties idProperties) {
        if (idProperties.getUseDefaultDatasource().booleanValue()) {
            Assert.state((defaultDatasource != null ? 1 : 0) != 0, (String)"\u9ed8\u8ba4\u6570\u636e\u6e90\u672a\u83b7\u53d6\u5230");
            return defaultDatasource;
        }
        Binder binder = Binder.get((Environment)environment);
        BindResult bindResult = binder.bind("elitesland.id.datasource", DataSourceProperties.class);
        if (!bindResult.isBound()) {
            throw new IllegalStateException("IdGenerator\u6570\u636e\u6e90\u52a0\u8f7d\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u5df2\u914d\u7f6e");
        }
        DataSourceProperties properties = (DataSourceProperties)bindResult.get();
        HikariDataSource datasource = (HikariDataSource)properties.initializeDataSourceBuilder().type(HikariDataSource.class).build();
        Properties hikariProperties = IdTool.hikariProperties(binder, "elitesland.id.datasource", null);
        if (hikariProperties != null) {
            datasource.setDataSourceProperties(hikariProperties);
        }
        datasource.setPoolName("cloudt-id-worker");
        return datasource;
    }

    private static Properties hikariProperties(Binder binder, String prefix, Properties defaultProperties) {
        String name = prefix + ".hikari";
        BindResult bindResult = binder.bind(name, Properties.class);
        if (bindResult.isBound()) {
            Properties properties = (Properties)bindResult.get();
            if (defaultProperties != null) {
                defaultProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)properties::putIfAbsent));
            }
            return properties;
        }
        return defaultProperties;
    }
}

