/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.data.support.id.provider.snowflake;

import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.data.support.id.provider.snowflake.WorkerInfo;
import com.elitescloud.boot.data.support.id.provider.snowflake.assigner.SnowflakeWorkerAssigner;
import com.elitescloud.boot.data.support.id.provider.snowflake.micro.Snowflake;
import com.elitescloud.boot.provider.CloudtIdCreator;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;

public class SnowflakeProvider
implements CloudtIdCreator,
InitializingBean {
    private static final Logger logger = CloudtBootLoggerFactory.REPO.getLogger(SnowflakeProvider.class);
    private final SnowflakeWorkerAssigner workerAssigner;
    private Snowflake snowflake;

    public SnowflakeProvider(SnowflakeWorkerAssigner workerAssigner) {
        this.workerAssigner = workerAssigner;
    }

    public Long create() {
        if (this.snowflake == null) {
            this.snowflake = this.buildSnowflake();
        }
        return this.snowflake.nextId();
    }

    public void afterPropertiesSet() throws Exception {
        this.snowflake = this.buildSnowflake();
    }

    public void refreshWorkerAssigner() {
        this.workerAssigner.refreshAlive();
    }

    public void destroy() {
        this.workerAssigner.destroy();
    }

    private Snowflake buildSnowflake() {
        WorkerInfo workerInfo = this.workerAssigner.assign();
        return new Snowflake(workerInfo.getDataCenterId(), workerInfo.getWorkerId(), true, 5L, true);
    }
}

