/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.data.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.orm.jpa.vendor.Database;

public class DatabaseUtil {
    public static Database getDatabaseType(DataSource dataSource) {
        String databaseProductName = DatabaseUtil.getDatabaseProductName(dataSource);
        if (databaseProductName.contains("mysql")) {
            return Database.MYSQL;
        }
        if (databaseProductName.contains("postgresql")) {
            return Database.POSTGRESQL;
        }
        if (databaseProductName.contains("oracle")) {
            return Database.ORACLE;
        }
        if (databaseProductName.contains("sql server")) {
            return Database.SQL_SERVER;
        }
        if (databaseProductName.contains("db2")) {
            return Database.DB2;
        }
        if (databaseProductName.contains("h2")) {
            return Database.H2;
        }
        if (databaseProductName.contains("mariadb")) {
            return Database.MYSQL;
        }
        if (databaseProductName.contains("derby")) {
            return Database.DERBY;
        }
        throw new RuntimeException("Unknown database type: " + databaseProductName);
    }

    private static String getDatabaseProductName(DataSource dataSource) {
        String string;
        block8: {
            Connection connection = dataSource.getConnection();
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                string = metaData.getDatabaseProductName().toLowerCase();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed to determine database type", e);
                }
            }
            connection.close();
        }
        return string;
    }
}

