/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.data.util;

import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import org.slf4j.Logger;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionUtil {
    private static final Logger logger = CloudtBootLoggerFactory.REPO.getLogger(TransactionUtil.class);

    private TransactionUtil() {
    }

    public static boolean isActualTransactionActive() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    public static void executeAfterCommit(Runnable task) {
        TransactionUtil.executeAfterCommit(task, false);
    }

    public static void executeAfterCommit(final Runnable task, boolean discardOnNoTransaction) {
        if (!TransactionUtil.isActualTransactionActive()) {
            logger.info("there is no transaction");
            if (discardOnNoTransaction) {
                logger.info("discard task");
                return;
            }
            task.run();
            return;
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                logger.info("after transaction committed");
                task.run();
            }

            public void afterCompletion(int status) {
                if (status == 1) {
                    logger.info("transaction rollback, discard task");
                    return;
                }
                if (status == 0) {
                    logger.info("transaction committed");
                    task.run();
                    return;
                }
                logger.info("unknown transaction status: {}, discard task", (Object)status);
            }
        });
    }
}

