package com.elitescloud.boot.datasecurity.dataauth.metadata;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.datasecurity.dataauth.enums.MateDataUdcCompropEnum;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysBizDataConstraintVO;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Table;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * <p>
 * 业务数据权限相关类
 * </p >
 *
 * @author niu.chen
 * @date 2021-07-07
 */
@Deprecated(forRemoval = true)
class DataAuthBusinessJpaUtil{

    /**
     * 是否开启有权限主要是测试使用。 默认关闭  测试的时候配置开启
     */
    @Getter
    @Setter
    private boolean dataPermissionEnable = false;

    /**
     * 数据权限过滤
     *

     * @param jpaQuery jpa查询对象
     * @param entityPathBase jps Q开通的类实例 如: QSysuser.qsysuser;
     * @param domainCode 查询主表的领域编码 UDC:COM:DOMAIN
     */
    public DataAuthResult<MateDatePredicateVo> dataAuthBusinessJpaUtil(
            JPAQuery<?> jpaQuery, EntityPathBase<?> entityPathBase, String domainCode) {
        // ======== 1. 获取当前用户信息包括各种权限对象。 获取判断当前用户信息 ========
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null ||
                user.getUser() == null /*||
                user.getUser().getSysDataRoleVOS() == null ||
                user.getUser().getSysDataRoleVOS().isEmpty()*/) {
            return DataAuthResult.fail("没有获取到当前用户权限信息");
        }
        //2.多个角色的业务数据信息合并一处
/*        Set<SysDataRoleVO> sysDataRoleVOS = user.getUser().getSysDataRoleVOS();
        List<SysBizDataConstraintVO> sysBizDataConstraintVOS = new ArrayList<>();
        for (SysDataRoleVO sysDataRoleVO : sysDataRoleVOS) {
            if ((sysDataRoleVO.getBusinessEnable() != null && sysDataRoleVO.getBusinessEnable())
                    || dataPermissionEnable) {//角色是否开启业务权限
                if (sysDataRoleVO.getSysBizDataConstraintVO() != null) {
                    sysBizDataConstraintVOS.addAll(sysDataRoleVO.getSysBizDataConstraintVO());
                }
            }
        }*/

        Predicate predicate = null;
        StringBuilder failString = new StringBuilder();//输出失败文字
        Class<?> jpaDoClass = entityPathBase.getType();
        PathMetadata  metadata= entityPathBase.getMetadata();
        //3.循环处理业务数据权限的配置,生成sql条件的谓词
//        for (SysBizDataConstraintVO sysBizDataConstraintVO : sysBizDataConstraintVOS) {
//            String fieldUdcType = sysBizDataConstraintVO.getFieldUdcType();//业务权限配置字段类型
////            String value = sysBizDataConstraintVO.getConstraintValues();//业务权限配置值
//            String fieldCode = sysBizDataConstraintVO.getFieldCode();//业务权限配置字段名
//            String tableCode = sysBizDataConstraintVO.getTableCode();//业务权限配置表名
//            String compareOpCode = sysBizDataConstraintVO.getCompareOpCode();//比较符编码
//            String domainCodeSys = sysBizDataConstraintVO.getDomainCode();//领域编码
//            //领域需要匹配
//            if (domainCodeSys.equals(domainCode)) {
//                //表和实体类配置是否对应
//                if (isTableName(jpaDoClass, tableCode)) {
//                    //表中字段配置和实体类是否对应
//                    if (isColumnName(jpaDoClass, fieldCode)) {
//                        //获得字段的逻辑业务类型的处理器
//                        BaseMateDataJpaInterface baseMateDataJpaInterface = MateDataJpaFactory.getNameService(fieldUdcType);
//                        if (baseMateDataJpaInterface == null) {//空表示没有获取到,可能是配置的字段类型不正确.
//                            failString.append(fieldUdcType).append("字段类型没有对应处理器,");
//                        } else {
//                            //根据比较符获取jap的Predicate查询条件对象.  如果null 则没有可能的是比较符配置错误.
//                            Predicate baseMateDataJpaPredicate =
//                                    getDataCompropPredicate(sysBizDataConstraintVO
//                                            , metadata
//                                            , baseMateDataJpaInterface);
//                            if (baseMateDataJpaPredicate == null) {
//                                failString.append(compareOpCode).append("对应的比较符处理器逻辑错误,");
//                            } else {
//                                //如果谓词null初始化  如果非空就合并追加谓词.
//                                if (predicate == null) {
//                                    predicate = baseMateDataJpaPredicate;
//                                } else {
//                                    predicate = ExpressionUtils.and(predicate, baseMateDataJpaPredicate);
//                                }
//                            }
//                        }
//                    } else {
//                        failString.append(fieldCode).append("字段没有找到,");
//                    }
//                }
//            }
//        }
        //返回结果
        MateDatePredicateVo mateDatePredicateVo =
                MateDatePredicateVo.builder()
                        .jpaPredicate(predicate)
//                        .sysBizDataConstraintVOS(sysBizDataConstraintVOS)
                        .build();
        //如果最终谓词空.  则是没有对应上配置信息,或者配置信息有错.
        if (predicate == null) {
            return DataAuthResult.fail(DateAuthResultCode.INVALID
                    , mateDatePredicateVo
                    , getTableName(jpaDoClass) + "没有找到匹配的配置条件表/字段:" + failString);
        } else {
            return DataAuthResult.ok(mateDatePredicateVo);
        }

    }

    //私有方法  设置并获取谓词BaseMateDataJpaInterface接口根据不同类型统一的抽象
    private Predicate getDataCompropPredicate(SysBizDataConstraintVO sysBizDataConstraintVO,
                                              PathMetadata metadata,
                                              BaseMateDataJpaInterface baseMateDataJpaInterface) {
        MateDataPredicateParam mateDataPredicateParam =
                setMateDataPredicateParam(metadata, sysBizDataConstraintVO);


        Predicate baseMateDataJpaPredicate = null;
        //in条件
        if (MateDataUdcCompropEnum.IN.toString().equals(sysBizDataConstraintVO.getCompareOpCode())) {
            baseMateDataJpaPredicate = baseMateDataJpaInterface.mateDataPredicateJpaIn(mateDataPredicateParam);
        }
        //对比条件
        else if (MateDataUdcCompropEnum.EQ.toString().equals(sysBizDataConstraintVO.getCompareOpCode())) {
            baseMateDataJpaPredicate = baseMateDataJpaInterface.mateDataPredicateJpaEq(mateDataPredicateParam);
        }
        //区间条件
        else if (MateDataUdcCompropEnum.BETWEEN.toString().equals(sysBizDataConstraintVO.getCompareOpCode())) {
            baseMateDataJpaPredicate = baseMateDataJpaInterface.mateDataPredicateJpaBetween(mateDataPredicateParam);
        }
        //包含条件
        else if (MateDataUdcCompropEnum.CONTAINS.toString().equals(sysBizDataConstraintVO.getCompareOpCode())) {
            baseMateDataJpaPredicate = baseMateDataJpaInterface.mateDataPredicateJpaContains(mateDataPredicateParam);
        }
        return baseMateDataJpaPredicate;
    }

    private MateDataPredicateParam setMateDataPredicateParam(PathMetadata metadata, SysBizDataConstraintVO sysBizDataConstraintVO) {
        MateDataPredicateParam mateDataPredicateParam = new MateDataPredicateParam();
        mateDataPredicateParam.setMetadata(metadata);
        mateDataPredicateParam.setTableCode(sysBizDataConstraintVO.getTableCode());
        mateDataPredicateParam.setFieldCode(CharSequenceUtil.toCamelCase(sysBizDataConstraintVO.getFieldCode()));
        mateDataPredicateParam.setFieldValue(sysBizDataConstraintVO.getConstraintValues());
        mateDataPredicateParam.setFieldUdcType(sysBizDataConstraintVO.getFieldUdcType());
        return mateDataPredicateParam;
    }


    //获取表名
    private static String getTableName(Class<?> clazz) {
        //            ElStringUtils.toCamelCase(fieldCode);
        //            ElStringUtils.toCamelCase(tableCode);
        Table annotation = clazz.getAnnotation(Table.class);
        if (annotation != null) {
            return annotation.name();
        }
        return null;
    }


//    //获取字段名
//    private static String getColumnName(Class<?> clazz, String fieldName) {
//        Method[] methods = clazz.getMethods();
//        for (Method method : methods) {
//            if (method.isAnnotationPresent(Column.class)) {
//                if (method.getName().equalsIgnoreCase("get" + fieldName)) {
//                    Column column = method.getAnnotation(Column.class);
//                    return column.name();
//                }
//            }
//        }
//        return null;
//    }

    //获取字段名是否存在DO实体中 不存在数据库权限无法生效.
    private static boolean isTableName(Class<?> clazz, String tableCode) {
        String tableDoName = getTableName(clazz);//获取do实体的配置物理表名
        return tableCode != null && !tableCode.equals("") && tableCode.equals(tableDoName);

    }

    //获取字段名是否存在DO实体中 不存在数据库权限无法生效.
    private static boolean isColumnName(Class<?> clazz, String fieldName) {
        Field[] fields = clazz.getDeclaredFields();
        List<Field> fieldsList = new ArrayList<>();
        Collections.addAll(fieldsList, fields);
        Class<?> pc = clazz.getSuperclass();
        if (pc != null) {
            Field[] pFields = pc.getDeclaredFields();
            Collections.addAll(fieldsList, pFields);
        }
        String columnName = CharSequenceUtil.toCamelCase(fieldName);
        boolean isColumn = false;
        for (Field field : fieldsList) {
            if (columnName.equals(field.getName())) {
                isColumn = true;
                break;
            }
        }
        return isColumn;
    }

    //比较编码值的拆分规则
    public static String[] splitFieldValue(String fieldValue) {
        if (StringUtils.isEmpty(fieldValue)) {
            return null;
        }
        return fieldValue.split(",");
    }
}
