package com.elitescloud.boot.datasecurity.dataauth.metadata;

import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.dsl.*;

/**
 * <p>
 * jpa元数据处理,拼接sql条件返回条件表,字段的代表类型的路径. 用于编写条件
 * </p >
 *
 * @author niu.chen
 * @date 2021-09-06
 */
class JpaMetadataUtil extends EntityPathBase {

    public JpaMetadataUtil(PathMetadata metadata) {
        super(metadata.getPathType().getType(), metadata);
    }

    public StringPath createStringField(String field) {
        return createString(field);
    }

    public BooleanPath createBooleanField(String field) {
        return createBoolean(field);
    }

    public <A extends Number & Comparable<?>> NumberPath<A> createNumberField(String field, Class<? super A> t) {
        return createNumber(field, t);
    }

    public <A extends Comparable> DateTimePath<A> createTimeField(String field, Class<? super A> t) {
//        java.time.LocalDateTime.class
        return createDateTime(field, t);
    }

}
