package com.elitescloud.boot.datasecurity.dataauth.metadata;

import com.elitescloud.boot.datasecurity.dataauth.enums.MateDateUdcFieldUdcTypeEnum;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 工厂类
 * </p >
 *
 * @author niu.chen
 * @date 2021-09-07
 */
@Data
public class MateDataJpaFactory {
    private static final Map<String, BaseMateDataJpaInterface> map = new HashMap<>();

    static {
        map.put(MateDateUdcFieldUdcTypeEnum.INT.toString(), new MateDataJpaTypeInteger());
        map.put(MateDateUdcFieldUdcTypeEnum.LINT.toString(), new MateDataJpaTypeLong());
        map.put(MateDateUdcFieldUdcTypeEnum.DATE.toString(), new MateDataJpaTypeDate());
        map.put(MateDateUdcFieldUdcTypeEnum.DOUBLE.toString(), new MateDataJpaTypeDouble());
        map.put(MateDateUdcFieldUdcTypeEnum.UDC.toString(), new MateDataJpaTypeUdc());
        map.put(MateDateUdcFieldUdcTypeEnum.STR.toString(), new MateDataJpaTypeText());
        map.put(MateDateUdcFieldUdcTypeEnum.CURRENCY.toString(), new MateDataJpaTypeCurrency());
        // ......
    }

    public static BaseMateDataJpaInterface getNameService(String name) {
        return map.get(name);
    }

}
