package com.elitescloud.boot.datasecurity.dataauth.metadata;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 货区类型的谓词处理
 * </p >
 *
 * @author niu.chen
 * @date 2021-09-07
 */
@Slf4j
class MateDataJpaTypeCurrency implements BaseMateDataJpaInterface {


    @Override
    public Predicate mateDataPredicateJpaIn(MateDataPredicateParam mateDataPredicateParam) {
        String[] strArray = DataAuthBusinessJpaUtil.splitFieldValue(mateDataPredicateParam.getFieldValue());
        if (strArray == null || strArray.length == 0) {
            return null;
        }
        List<BigDecimal> list = new ArrayList<>();
        for (String s : strArray) {
            list.add(new BigDecimal(s));
        }
        NumberPath<BigDecimal> numberPath =
                new JpaMetadataUtil(mateDataPredicateParam.getMetadata())
                        .createNumberField(mateDataPredicateParam.getFieldCode(), BigDecimal.class);
        return numberPath.in(list);
    }

    @Override
    public Predicate mateDataPredicateJpaEq(MateDataPredicateParam mateDataPredicateParam) {
        String[] strArray = DataAuthBusinessJpaUtil.splitFieldValue(mateDataPredicateParam.getFieldValue());
        if (strArray == null || strArray.length == 0) {
            return null;
        }
        BigDecimal strDouble = new BigDecimal(strArray[0]);
        NumberPath<BigDecimal> numberPath =
                new JpaMetadataUtil(mateDataPredicateParam.getMetadata())
                        .createNumberField(mateDataPredicateParam.getFieldCode(), BigDecimal.class);
        return numberPath.eq(strDouble);
    }

    @Override
    @Deprecated
    public Predicate mateDataPredicateJpaContains(MateDataPredicateParam mateDataPredicateParam) {
        log.error("暂时不支持Contains");
        return null;
    }

    @Override
    @Deprecated
    public Predicate mateDataPredicateJpaBetween(MateDataPredicateParam mateDataPredicateParam) {
        log.error("暂时不支持Contains");
        return null;
    }
}
