package com.elitescloud.boot.datasecurity.dataauth.metadata;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 浮点类型的谓词处理
 * </p >
 *
 * @author niu.chen
 * @date 2021-09-07
 */
@Slf4j
class MateDataJpaTypeDouble implements BaseMateDataJpaInterface {


    @Override
    public Predicate mateDataPredicateJpaIn(MateDataPredicateParam mateDataPredicateParam) {
        String[] strArray = DataAuthBusinessJpaUtil.splitFieldValue(mateDataPredicateParam.getFieldValue());
        if (strArray == null || strArray.length == 0) {
            return null;
        }
        List<Double> list = new ArrayList<>();
        for (String s : strArray) {
            list.add(Double.valueOf(s));
        }
        NumberPath<Double> numberPath =
                new JpaMetadataUtil(mateDataPredicateParam.getMetadata())
                        .createNumberField(mateDataPredicateParam.getFieldCode(), Double.class);
        return numberPath.in(list);
    }

    @Override
    public Predicate mateDataPredicateJpaEq(MateDataPredicateParam mateDataPredicateParam) {
        String[] strArray = DataAuthBusinessJpaUtil.splitFieldValue(mateDataPredicateParam.getFieldValue());
        if (strArray == null || strArray.length == 0) {
            return null;
        }
        Double strDouble = Double.valueOf(strArray[0]);
        NumberPath<Double> numberPath =
                new JpaMetadataUtil(mateDataPredicateParam.getMetadata()).createNumberField(mateDataPredicateParam.getFieldCode(), Double.class);
        return numberPath.eq(strDouble);
    }

    @Override
    @Deprecated
    public Predicate mateDataPredicateJpaContains(MateDataPredicateParam mateDataPredicateParam) {
        log.error("暂时不支持Contains");
        return null;
    }

    @Override
    @Deprecated
    public Predicate mateDataPredicateJpaBetween(MateDataPredicateParam mateDataPredicateParam) {
        log.error("暂时不支持Between");
        return null;
    }
}
