package com.elitescloud.boot.datasecurity.dataauth.metadata;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.StringPath;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 文本类型的谓词处理
 * </p >
 *
 * @author niu.chen
 * @date 2021-09-07
 */
@Slf4j
class MateDataJpaTypeText implements BaseMateDataJpaInterface {


    @Override
    public Predicate mateDataPredicateJpaIn(MateDataPredicateParam mateDataPredicateParam) {
        String fieldValue = mateDataPredicateParam.getFieldValue();
        String[] strArray = DataAuthBusinessJpaUtil.splitFieldValue(fieldValue);
        if (strArray == null || strArray.length == 0) {
            return null;
        }
        List<String> list = new ArrayList<>(Arrays.asList(strArray));
        StringPath stringPath =
                new JpaMetadataUtil(mateDataPredicateParam.getMetadata())
                        .createStringField(mateDataPredicateParam.getFieldCode());
        return stringPath.in(list);
    }


    @Override
    public Predicate mateDataPredicateJpaEq(MateDataPredicateParam mateDataPredicateParam) {

        String[] strArray = DataAuthBusinessJpaUtil.splitFieldValue(mateDataPredicateParam.getFieldValue());
        if (strArray == null || strArray.length == 0) {
            return null;
        }
        StringPath stringPath =
                new JpaMetadataUtil(mateDataPredicateParam.getMetadata())
                        .createStringField(mateDataPredicateParam.getFieldCode());
        return stringPath.eq(strArray[0]);
    }

    @Override
    public Predicate mateDataPredicateJpaContains(MateDataPredicateParam mateDataPredicateParam) {
        String[] strArray = DataAuthBusinessJpaUtil.splitFieldValue(mateDataPredicateParam.getFieldValue());
        if (strArray == null || strArray.length == 0) {
            return null;
        }
        StringPath stringPath =
                new JpaMetadataUtil(mateDataPredicateParam.getMetadata())
                        .createStringField(mateDataPredicateParam.getFieldCode());
        return stringPath.like("%" + strArray[0] + "%");
    }

    @Override
    @Deprecated
    public Predicate mateDataPredicateJpaBetween(MateDataPredicateParam mateDataPredicateParam) {
        log.error("文本暂时不支持Between");
        return null;
    }
}
