package com.elitescloud.boot.datasecurity.dpr.beansearcher;


import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.MapSearcher;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.cloudt.core.tenant.support.TenantClientProvider;

/**
 * BS的工厂模式 用于返回检索器 BS默认检索器或架构租户+数据权限检索器
 *
 * @author : chen.niu
 * @date 2023/1/14 10:09
 */
public class BeanSearcherFactory {
//    private Map<String, BeanSearcher> beanSearcherServiceMap = new HashMap<>();

    private final BeanSearcher beanSearcher;
    private final MapSearcher mapSearcher;
    private final TenantClientProvider tenantClientProvider;
    private final RoleDataPermissionRuleService dataPermissionRuleService;

    public BeanSearcherFactory(BeanSearcher beanSearcher, MapSearcher mapSearcher, TenantClientProvider tenantClientProvider, RoleDataPermissionRuleService dataPermissionRuleService) {
        this.beanSearcher = beanSearcher;
        this.mapSearcher = mapSearcher;
        this.tenantClientProvider = tenantClientProvider;
        this.dataPermissionRuleService = dataPermissionRuleService;
    }

    /**
     * BeanSearcher。 根据检索条件需求填写枚举。 默认的是不支持多租户和数据权限
     *
     * @param cloudBeanSearcherEnum 检索条件枚举
     * @return 检索器接口实现
     */
    public BeanSearcher getBeanSearcherService(CloudBeanSearcherEnum cloudBeanSearcherEnum) {
        if (cloudBeanSearcherEnum == null) {
            throw new RuntimeException("CloudBeanSearcherEnum NULL");
        }
        switch (cloudBeanSearcherEnum) {
            case BS_DEFAULT:
                return beanSearcher;
            case BS_TENANT_AUTH:
                return new CloudTenantAuthBeanSearcher(beanSearcher, tenantClientProvider, dataPermissionRuleService);
            case BS_TENANT:
                return new CloudTenantBeanSearcher(beanSearcher, tenantClientProvider, dataPermissionRuleService);
            case BS_AUTH:
                throw new RuntimeException("暂未实现只数据权限不租户");
            default:
                throw new RuntimeException("枚举异常");
        }
    }

    /**
     * BeanSearcher 检索器默认接口实现返回。
     *
     * @return 检索器接口实现
     */
    public BeanSearcher getBeanSearcherService() {
        return beanSearcher;
    }

    public MapSearcher getMapBeanSearcherService() {
        return mapSearcher;
    }

    public MapSearcher getMapBeanSearcherService(CloudBeanSearcherEnum cloudBeanSearcherEnum) {
        if (cloudBeanSearcherEnum == null) {
            throw new RuntimeException("CloudMapBeanSearcherEnum NULL");
        }
        switch (cloudBeanSearcherEnum) {
            case BS_DEFAULT:
                return mapSearcher;
            case BS_TENANT_AUTH:
                return new CloudTenantAuthMapBeanSearcher(mapSearcher, tenantClientProvider, dataPermissionRuleService);
            case BS_TENANT:
                return new CloudTenantMapBeanSearcher(mapSearcher, tenantClientProvider, dataPermissionRuleService);
            case BS_AUTH:
                throw new RuntimeException("暂未实现只数据权限不租户");
            default:
                throw new RuntimeException("枚举异常");
        }
    }
}
