package com.elitescloud.boot.datasecurity.dpr.beansearcher;


import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.SearchResult;
import cn.zhxu.bs.util.FieldFns;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.cloudt.core.tenant.support.TenantClientProvider;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : chen.niu
 * @description :
 * : 2023/1/16 15:19
 */
class CloudTenantBeanSearcher  implements BeanSearcher {
    private final BeanSearcher beanSearcher;

    private final TenantClientProvider tenantClientProvider;

    private final RoleDataPermissionRuleService dataPermissionRuleService;

    public CloudTenantBeanSearcher(BeanSearcher beanSearcher, TenantClientProvider tenantClientProvider, RoleDataPermissionRuleService dataPermissionRuleService) {
        this.beanSearcher = beanSearcher;
        this.tenantClientProvider = tenantClientProvider;
        this.dataPermissionRuleService = dataPermissionRuleService;
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass) {
        return search(beanClass,new HashMap<>());
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap) {

        var userMap = dataPermissionRuleService.tenantSearcherHandleEngine(beanClass
                , paraMap);
        return beanSearcher.search(beanClass, userMap.build());
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, String summaryField) {
        throw new RuntimeException("数据权限，暂不支持统计检索");
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap, String summaryField) {
        throw new RuntimeException("数据权限，暂不支持统计检索");
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, FieldFns.FieldFn<T, ?> summaryField) {
        throw new RuntimeException("数据权限，暂不支持统计检索");
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap, FieldFns.FieldFn<T, ?> summaryField) {
        throw new RuntimeException("数据权限，暂不支持统计检索");
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, String[] summaryFields) {
        throw new RuntimeException("数据权限，暂不支持统计检索");
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap, String[] summaryFields) {
        var userMap = dataPermissionRuleService.tenantSearcherHandleEngine(beanClass
                , paraMap);
        return beanSearcher.search(beanClass, userMap.build(), summaryFields);
    }

    @Override
    public <T> T searchFirst(Class<T> beanClass) {
        return searchFirst(beanClass,new HashMap<>());
    }

    @Override
    public <T> T searchFirst(Class<T> beanClass, Map<String, Object> paraMap) {
        var userMap = dataPermissionRuleService.tenantSearcherHandleEngine(beanClass
                , paraMap);
        return beanSearcher.searchFirst(beanClass, userMap.build());
    }

    @Override
    public <T> List<T> searchList(Class<T> beanClass) {
        return searchList(beanClass,new HashMap<>());
    }

    @Override
    public <T> List<T> searchList(Class<T> beanClass, Map<String, Object> paraMap) {
        var userMap = dataPermissionRuleService.tenantSearcherHandleEngine(beanClass
                , paraMap);
        return beanSearcher.searchList(beanClass, userMap.build());
    }

    @Override
    public <T> List<T> searchAll(Class<T> beanClass) {
        return searchAll(beanClass,new HashMap<>());
    }

    @Override
    public <T> List<T> searchAll(Class<T> beanClass, Map<String, Object> paraMap) {
        var userMap = dataPermissionRuleService.tenantSearcherHandleEngine(beanClass
                , paraMap);
        return beanSearcher.searchAll(beanClass, userMap.build());
    }

    @Override
    public <T> Number searchCount(Class<T> beanClass) {
        return searchCount(beanClass,new HashMap<>());
    }

    @Override
    public <T> Number searchCount(Class<T> beanClass, Map<String, Object> paraMap) {
        var userMap = dataPermissionRuleService.tenantSearcherHandleEngine(beanClass
                , paraMap);
        return beanSearcher.searchCount(beanClass, userMap.build());
    }

    @Override
    public <T> Number searchSum(Class<T> beanClass, String field) {
        throw new RuntimeException("数据权限，暂不支持统计检索");
    }

    @Override
    public <T> Number searchSum(Class<T> beanClass, Map<String, Object> paraMap, String field) {
        var userMap = dataPermissionRuleService.tenantSearcherHandleEngine(beanClass
                , paraMap);
        return beanSearcher.searchSum(beanClass, userMap.build(), field);
    }

    @Override
    public <T> Number searchSum(Class<T> beanClass, FieldFns.FieldFn<T, ?> field) {
        throw new RuntimeException("数据权限，暂不支持统计检索");
    }

    @Override
    public <T> Number searchSum(Class<T> beanClass, Map<String, Object> paraMap, FieldFns.FieldFn<T, ?> field) {
        throw new RuntimeException("数据权限，暂不支持统计检索");
    }

    @Override
    public <T> Number[] searchSum(Class<T> beanClass, String[] fields) {
        throw new RuntimeException("数据权限，暂不支持统计检索");
    }

    @Override
    public <T> Number[] searchSum(Class<T> beanClass, Map<String, Object> paraMap, String[] fields) {
        var userMap = dataPermissionRuleService.tenantSearcherHandleEngine(beanClass
                , paraMap);
        return beanSearcher.searchSum(beanClass, userMap.build(), fields);
    }
}
