/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.dpr.service.impl;

import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleCacheInterface;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.common.util.RedisUtils;
import com.elitescloud.cloudt.context.threadpool.ThreadPoolHolder;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import com.elitescloud.cloudt.system.service.RoleAppApiDataPermissionRpcService;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleDataPermissionRuleCacheImpl
implements RoleDataPermissionRuleCacheInterface {
    private static final Logger log = LoggerFactory.getLogger(RoleDataPermissionRuleCacheImpl.class);
    private final RedisUtils redisUtils;
    private final RoleAppApiDataPermissionRpcService roleAppApiDataPermissionRpcService;
    public static final String TOKEN_PREFIX = "DRP_TOKEN_";
    public static final Integer REDIS_UTILS_TIME = 120;
    public static final Integer CACHE_MAXIMUM_SIZE = 3000;
    public static final Integer CACHE_EXPIRE_AFTER_WRITE = 5;
    private static final Cache<String, SysDprRoleApiRowColumnRuleDTO> TOKEN_DPR_LOCAL_CACHE = Caffeine.newBuilder().maximumSize((long)CACHE_MAXIMUM_SIZE.intValue()).expireAfterWrite(Duration.ofMinutes(CACHE_EXPIRE_AFTER_WRITE.intValue())).build();

    public RoleDataPermissionRuleCacheImpl(RedisUtils redisUtils, RoleAppApiDataPermissionRpcService roleAppApiDataPermissionRpcService) {
        this.redisUtils = redisUtils;
        this.roleAppApiDataPermissionRpcService = roleAppApiDataPermissionRpcService;
    }

    @Override
    public SysDprRoleApiRowColumnRuleDTO roleDataPermissionRuleRpc(String token) {
        try {
            ApiResult apiResult = this.roleAppApiDataPermissionRpcService.getRoleAppApiDataRulePermission();
            if (!apiResult.isSuccess()) {
                throw new BusinessException("\u8fdc\u7a0b\u8c03\u7528\u83b7\u53d6\u89d2\u8272\u6570\u636e\u6743\u9650\u5f02\u5e38\uff1a" + apiResult.getMsg());
            }
            if (apiResult.getData() == null) {
                log.debug("\u6570\u636e\u6743\u9650\uff1a\u5f53\u524dtoken\u8d26\u53f7\uff0c\u6ca1\u6709\u4efb\u4f55\u6570\u636e\u6743\u9650\u914d\u7f6e\u3002\u8fd4\u56deNULL\u3002   token:{},data:{}", (Object)token, apiResult.getData());
                return null;
            }
            this.tokenDprLocalCacheSave(token, (SysDprRoleApiRowColumnRuleDTO)apiResult.getData());
            if (apiResult.getData() != null) {
                CompletableFuture.runAsync(() -> {
                    if (!this.tokenRedisCacheSave(token, (SysDprRoleApiRowColumnRuleDTO)apiResult.getData()).booleanValue()) {
                        log.error("\u6570\u636e\u6743\u9650\uff1a\u7528\u6237\u6570\u636e\u6743\u9650Redis\u7f13\u5b58\u5931\u8d25\uff0c\u8bf7\u5c3d\u5feb\u6392\u67e5 token:{},data:{}", (Object)token, apiResult.getData());
                    } else {
                        log.debug("\u6570\u636e\u6743\u9650\uff1aToken redis\u7f13\u5b58\u6210\u529f token:{},data:{}", (Object)token, apiResult.getData());
                    }
                }, this.createExecutor());
            } else {
                log.debug("\u6570\u636e\u6743\u9650\uff1adata\u6570\u636e\u7a7a\uff0c\u8df3\u8fc7Redis\u7f13\u5b58\u3002");
            }
            return (SysDprRoleApiRowColumnRuleDTO)apiResult.getData();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6570\u636e\u6743\u9650\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("\u83b7\u53d6\u6570\u636e\u6743\u9650\u5f02\u5e38\uff1a{}" + e.getMessage());
        }
    }

    private Executor createExecutor() {
        return ThreadPoolHolder.createThreadPool((String)"RoleDataPermission-", (Integer)8, (Integer)64);
    }

    @Override
    public void tokenDprLocalCacheSave(String token, SysDprRoleApiRowColumnRuleDTO roleRuleGroupDtoList) {
        TOKEN_DPR_LOCAL_CACHE.put((Object)token, (Object)roleRuleGroupDtoList);
    }

    @Override
    public Boolean tokenRedisCacheSave(String token, SysDprRoleApiRowColumnRuleDTO roleRuleGroupDtoList) {
        if (!this.redisUtils.set(TOKEN_PREFIX + token, (Object)roleRuleGroupDtoList, (long)REDIS_UTILS_TIME.intValue(), TimeUnit.MINUTES)) {
            log.error("\u6570\u636e\u6743\u9650\uff1aredis\u7f13\u5b58\u6743\u9650\u4fe1\u606f\u5931\u8d25 token:{}  -  data:{}", (Object)token, (Object)roleRuleGroupDtoList);
            return false;
        }
        return true;
    }

    @Override
    public Optional<SysDprRoleApiRowColumnRuleDTO> getTokenDprLocalCache(String token) {
        SysDprRoleApiRowColumnRuleDTO permissions = (SysDprRoleApiRowColumnRuleDTO)TOKEN_DPR_LOCAL_CACHE.getIfPresent((Object)token);
        if (permissions != null) {
            return Optional.of(permissions);
        }
        log.debug("\u6570\u636e\u6743\u9650\uff1a\u6ca1\u6709\u8bfb\u53d6\u5230\u672c\u5730\u7f13\u5b58 \uff1a" + token);
        return Optional.empty();
    }

    @Override
    public Optional<SysDprRoleApiRowColumnRuleDTO> getTokenDprRedisCache(String token) {
        SysDprRoleApiRowColumnRuleDTO sysDprRoleApiRuleGroupDTOList = (SysDprRoleApiRowColumnRuleDTO)this.redisUtils.get(TOKEN_PREFIX + token);
        if (sysDprRoleApiRuleGroupDTOList != null) {
            this.tokenDprLocalCacheSave(token, sysDprRoleApiRuleGroupDTOList);
            return Optional.of(sysDprRoleApiRuleGroupDTOList);
        }
        log.debug("\u6570\u636e\u6743\u9650\uff1a\u6ca1\u6709\u8bfb\u53d6\u5230redis\u6570\u636e\u6743\u9650" + token);
        return Optional.empty();
    }
}

