package com.elitescloud.boot.datasecurity.dpr.content;


import com.elitescloud.cloudt.system.vo.DprUdcVO;

import java.util.ArrayList;
import java.util.List;

/**
 * 系统上下文内置类型枚举
 *
 * @author chen**/
public enum DprSysInternallyEnum implements BasicUdcEnumInterface {
    DPR_SYS_INTERNALLY_ALL("SYSTEM", "DPR_SYS_INTERNALLY", "系统上下文内置类型枚举", "全部",0,""),

    DPR_SYS_INTERNALLY_EMPLOYEE("SYSTEM", "DPR_SYS_INTERNALLY", "系统上下文内置类型枚举", "本人",1,"secUserId"),
    DPR_SYS_INTERNALLY_EMPLOYEE_SUB("SYSTEM", "DPR_SYS_INTERNALLY", "系统上下文内置类型枚举", "本人下级",2,"secUserId"),
    DPR_SYS_INTERNALLY_EMPLOYEE_LOCAL_SUB("SYSTEM", "DPR_SYS_INTERNALLY", "系统上下文内置类型枚举", "本人及下级",3,"secUserId"),

    DPR_SYS_INTERNALLY_ORG("SYSTEM", "DPR_SYS_INTERNALLY", "系统上下文内置类型枚举", "所在组织",4,"secBuId"),
    DPR_SYS_INTERNALLY_ORGSUB("SYSTEM", "DPR_SYS_INTERNALLY", "系统上下文内置类型枚举", "下级组织",5,"secBuId"),
    DPR_SYS_INTERNALLY_ORG_LOCAL_SUB("SYSTEM", "DPR_SYS_INTERNALLY", "系统上下文内置类型枚举", "所在组织及下级组织",6,"secBuId"),


    ;

    /*** 应用编码*/
    private final String domainCode;
    /*** 枚举/udc的大类 */
    private final String udcCode;
    /*** 枚举.udc的大类名称*/
    private final String udcName;
    /*** 当前枚举值字符串的描述*/
    private final String valueDescription;
    /*** 排序*/
    private final int sortNo;

    /*** 枚举.内置类型关联的字段值，用于展示，可以空*/
    private final String fieldValue;
    private final DprUdcVO sysUdcVO;

    DprSysInternallyEnum(String domainCode, String udcCode,
                         String udcName, String description,
                         int sortNo,String fieldValue
    ) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.valueDescription = description;
        this.fieldValue=fieldValue;
        this.sysUdcVO = this.newUdcVo(domainCode, udcCode, udcName, description, sortNo, this.name());
        this.sysUdcVO.setEs1(fieldValue);
    }

    @Override
    public DprUdcVO getUdcVO() {
        return this.sysUdcVO;
    }

    @Override
    public String getValueDescription() {
        return valueDescription;
    }

    public static String getValue(String key) {
        for (var ele : values()) {
            if (ele.name().equals(key)) {
                return ele.getValueDescription();
            }
        }
        return null;
    }
    public static List<DprUdcVO> getSysUdcVOList() {
        ArrayList<DprUdcVO> sysUdcVOList = new ArrayList<>();
        for (var ele : values()) {
            sysUdcVOList.add(ele.getUdcVO());
        }
        return sysUdcVOList;
    }
}
