package com.elitescloud.boot.datasecurity.dataauth;

import lombok.Data;

import java.util.Set;

/**
 * @author Chris
 * @date 2021-08-12
 */
@Data
public class AuthScope {

    /**
     * 绑定BU
     */
    private Set<Long> buIds;

    /**
     * 绑定BU 的 code path
     */
    private Set<String> buCodePath;

    /**
     * 子 bu id 列表，包含自己
     */
    private Set<Long> childBuIds;

    /**
     * 自定义bu
     */
    private Set<Long> customizedBuIds;

    /**
     * 绑定员工
     */
    private Set<Long> empIds;

    /**
     * 绑定员工的 code path
     */
    private Set<String> empCodePath;

    /**
     * 子 emp id 列表，包含自己
     */
    private Set<Long> childEmpIds;

    /**
     * 自定义员工
     */
    private Set<Long> customizedEmpIds;

    /**
     * 绑定公司，包含自定义公司，二合一
     */
    private Set<Long> ouIds;

}
