package com.elitescloud.boot.datasecurity.dpr.content;


import com.elitescloud.cloudt.system.vo.DprUdcVO;

import java.util.ArrayList;
import java.util.List;

/**
 * 角色自定义组件枚举
 * @author chen
 */

public enum DprRoleCustomAppEnum implements BasicUdcEnumInterface {
    /*** 系统*/
    DPR_ROLE_CUSTOM_APP_EmpIdIn("SYSTEM", "DPR_ROLE_CUSTOM_APP", "角色自定义组件枚举", "员工多选", 1),
    /*** 业务*/
    DPR_ROLE_CUSTOM_APP_OrgIdIn("SYSTEM", "DPR_ROLE_CUSTOM_APP", "角色自定义组件枚举", "组织多选", 2),
    ;
    /*** 应用编码*/
    private final String domainCode;
    /*** 枚举/udc的大类 */
    private final String udcCode;
    /*** 枚举.udc的大类名称*/
    private final String udcName;
    /*** 当前枚举值字符串的描述*/
    private final String valueDescription;
    /*** 排序*/
    private final int sortNo;
    /*** UCC封装对象*/
    private final DprUdcVO sysUdcVO;

    DprRoleCustomAppEnum(String domainCode, String udcCode,
                         String udcName, String description,
                         int sortNo
    ) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.valueDescription = description;
        this.sysUdcVO = this.newUdcVo(domainCode, udcCode, udcName, description, sortNo, this.name());
    }

    @Override
    public DprUdcVO getUdcVO() {
        return this.sysUdcVO;
    }

    @Override
    public String getValueDescription() {
        return valueDescription;
    }

    public static String getValue(String key) {
        for (var ele : values()) {
            if (ele.name().equals(key)) {
                return ele.getValueDescription();
            }
        }
        return null;
    }
    public static List<DprUdcVO> getSysUdcVOList() {
        ArrayList<DprUdcVO> sysUdcVOList = new ArrayList<>();
        for (var ele : values()) {
            sysUdcVOList.add(ele.getUdcVO());
        }
        return sysUdcVOList;
    }
}
