package com.elitescloud.boot.datasecurity.dpr.content;

import com.elitescloud.cloudt.system.vo.DprUdcVO;

import java.util.ArrayList;
import java.util.List;

/**
 * 规则分组类型 作用：分组显示，用于管理和区分。
 *
 * @author chen
 */

public enum DprRuleGroupTypeEnum implements BasicUdcEnumInterface {
    /*** 公用规则组*/
    DPR_RULE_GROUP_TYPE_COMMON("SYSTEM", "DPR_RULE_GROUP_TYPE", "规则分组类型", "公用规则组", 1),
    /*** 定制规则组*/
    DPR_RULE_GROUP_TYPE_PRIVATE("SYSTEM", "DPR_RULE_GROUP_TYPE", "规则分组类型", "定制规则组", 2),
    ;
    /*** 应用编码*/
    private final String domainCode;
    /*** 枚举/udc的大类 */
    private final String udcCode;
    /*** 枚举.udc的大类名称*/
    private final String udcName;
    /*** 当前枚举值字符串的描述*/
    private final String valueDescription;
    /*** 排序*/
    private final int sortNo;
    private final DprUdcVO sysUdcVO;

    DprRuleGroupTypeEnum(String domainCode, String udcCode,
                         String udcName, String description,
                         int sortNo
    ) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.valueDescription = description;
        this.sysUdcVO = this.newUdcVo(domainCode, udcCode, udcName, description, sortNo, this.name());
    }

    @Override
    public DprUdcVO getUdcVO() {
        return this.sysUdcVO;
    }

    @Override
    public String getValueDescription() {
        return valueDescription;
    }

    public static String getValue(String key) {
        for (var ele : values()) {
            if (ele.name().equals(key)) {
                return ele.getValueDescription();
            }
        }
        return null;
    }

    public static List<DprUdcVO> getSysUdcVOList() {
        ArrayList<DprUdcVO> sysUdcVOList = new ArrayList<>();
        for (var ele : values()) {
            sysUdcVOList.add(ele.getUdcVO());
        }
        return sysUdcVOList;
    }

}
