package com.elitescloud.boot.datasecurity.dpr.service.util;

import cn.hutool.core.collection.ListUtil;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.datasecurity.common.DataSecurityConstant;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.system.dto.SysDpcRoleApiFieldsDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/3/29 17:29
 */
@Slf4j
public class RoleDatePermissionColumnUtil {
    public final static String[] GROUP_STR = new String[]{"DPRaa", "DPRbb", "DPRcc", "DPRdd", "DPRee", "DPRff", "DPRgg", "DPRhh", "DPRii", "DPRjj", "DPRkk", "DPRll", "DPRmm", "DPRnn", "DPRoo", "DPRpp", "DPRqq", "DPRrr", "DPRss", "DPRtt", "DPRuu", "DPRvv", "DPRww", "DPRxx", "DPRyy", "DPRzz"};
    public final static String SB_MAP_GROUP_EXPR = MapBuilder.GROUP_EXPR;

    /***租户id分组常量**/
    public final static String TENANT_ID_GROUP="tenantIdGroup";

    /****设置列权限字段  多个角色的同一个API合并成一个。****/
    public static void setColumnMapBuilder(List<SysDpcRoleApiFieldsDTO> columnDto, MapBuilder mapBuilder) {

        StringBuilder columnOnlStr = new StringBuilder();
        StringBuilder columnExcludeStr = new StringBuilder();
        for (SysDpcRoleApiFieldsDTO dto : columnDto) {
            if (dto.getFieldApiVisible()) {
                if (columnOnlStr.length() == 0) {
                    columnOnlStr.append(dto.getFieldName());
                } else {
                    columnOnlStr.append(",").append(dto.getFieldName());
                }
            } else {
                if (columnExcludeStr.length() == 0) {
                    columnExcludeStr.append(dto.getFieldName());
                } else {
                    columnExcludeStr.append(",").append(dto.getFieldName());
                }
            }
        }

        if (columnOnlStr.length() != 0) {
            mapBuilder.onlySelect(columnOnlStr.toString());
        }
        if (columnExcludeStr.length() != 0) {
            mapBuilder.selectExclude(columnExcludeStr.toString());
        }
    }


    /***
     * 根据原SQL的条件分组关系+租户条件分组关系表达式，构建一个新的分组关系字符串给规则分组表达式使用
     * @param mapBuilder 新构造器
     * @param params 原始sql的参数
     * @return 拼接后的表达式
     */
    public static String tenantAuthBuilder(TenantClientProvider tenantClientProvider,
                                       MapBuilder mapBuilder, Map<String, Object> params) {
        var userInfo = SecurityContextUtil.currentUser();
        Long tenantId = -1L;
        //如果开启多租户
        if (tenantClientProvider.enabledTenant()) {
            if (userInfo != null && userInfo.getTenantId() != null) {
                tenantId = userInfo.getTenantId();
            } else {
                var tenant = tenantClientProvider.getSessionTenant();
                if (tenant != null) {
                    tenantId = tenant.getId();
                }
            }
        }
        mapBuilder.group(TENANT_ID_GROUP);
        mapBuilder.field(BaseModel::getTenantId, tenantId).op(FieldOps.Equal);
        String bsGroupExpr = getBeanSearcherGroupExpr(params);
        StringBuffer groupExpr = new StringBuffer();
        //如果原始bs已经分组，需要追加分组
        if (bsGroupExpr != null && bsGroupExpr.length() > 0) {
            groupExpr.append(bsGroupExpr).append("&"+TENANT_ID_GROUP);
        } else {
            groupExpr.append(TENANT_ID_GROUP);
        }

        return groupExpr.toString();
    }

    /***
     * 根据原SQL的条件分组关系+租户条件分组关系表达式，构建一个新的分组关系字符串给规则分组表达式使用
     * @param mapBuilder 新构造器
     * @param params 原始sql的参数
     * @return 拼接后的表达式
     */
    public static String tenantBuilder(TenantClientProvider tenantClientProvider,
                                       MapBuilder mapBuilder, Map<String, Object> params) {
        var userInfo = SecurityContextUtil.currentUser();
        Long tenantId = -1L;
        //如果开启多租户
        if (tenantClientProvider.enabledTenant()) {
            if (userInfo != null && userInfo.getTenantId() != null) {
                tenantId = userInfo.getTenantId();
            } else {
                var tenant = tenantClientProvider.getSessionTenant();
                if (tenant != null) {
                    tenantId = tenant.getId();
                }
            }

        }

        String bsGroupExpr = getBeanSearcherGroupExpr(params);
        StringBuffer groupExpr = new StringBuffer();
        //如果原始bs已经分组，需要追加分组
        if (bsGroupExpr != null && bsGroupExpr.length() > 0) {
            mapBuilder.group(TENANT_ID_GROUP);
            mapBuilder.field(BaseModel::getTenantId, tenantId).op(FieldOps.Equal);
            groupExpr.append(bsGroupExpr).append("&"+TENANT_ID_GROUP);
        } else {
            mapBuilder.field(BaseModel::getTenantId, tenantId).op(FieldOps.Equal);
            groupExpr.append(TENANT_ID_GROUP);
        }

        return groupExpr.toString();
    }

    /***bs返回分组表达式参数**/
    public static String getBeanSearcherGroupExpr(Map<String, Object> params) {
        return params.get(SB_MAP_GROUP_EXPR) != null ? params.get(SB_MAP_GROUP_EXPR).toString() : null;
    }

    /***bs添加分组表达式参数**/
    public static void addSetBeanSearcherGroupExpr(Map<String, Object> params, String groupExpr) {
        Object drpGroupExpr = params.get(SB_MAP_GROUP_EXPR);
        params.put(SB_MAP_GROUP_EXPR, drpGroupExpr + groupExpr);
    }


    /**拼接跟组表达式**/
    public static void jointGroupExpr(int i, int size, SysDprRoleApiDataRuleListQueryDTO rule, String gStr, StringBuilder groupExpr) {
        if (size == 0) {
            return;
        }
        //开头
        if (i == 0) {
            groupExpr.append("(").append(gStr);
            if (size == 1) {
                groupExpr.append(")");
            }
        }
        //结尾
        else if (i == size - 1) {
            if (rule.getDprRuleRelation().equals(DprRuleRelationEnum.DPR_RULE_RELATION_OR.name())) {
                groupExpr.append("|").append(gStr).append(")");
            } else if (rule.getDprRuleRelation().equals(DprRuleRelationEnum.DPR_RULE_RELATION_AND.name())) {
                groupExpr.append("&").append(gStr).append(")");
            } else {
                DataPermissionRuleServiceUtil.throwRuntimeException("非法的DprRuleRelation 规则关系，请尽快联系管理员。：", rule);
            }
        }
        //中间
        else {
            if (rule.getDprRuleRelation().equals(DprRuleRelationEnum.DPR_RULE_RELATION_OR.name())) {
                groupExpr.append("|").append(gStr);
            } else if (rule.getDprRuleRelation().equals(DprRuleRelationEnum.DPR_RULE_RELATION_AND.name())) {
                groupExpr.append("&").append(gStr);
            } else {
                DataPermissionRuleServiceUtil.throwRuntimeException("非法的DprRuleRelation 规则关系，请尽快联系管理员。：", rule);
            }
        }
    }


    /**
     * 根据请求的path路径  比对当前用户全部的api数据权限配置。 找到对应的api数据权限配置规则组和规则信息并返回
     *
     * @param pathObj 路径传参时，路径参数。 通前端规则配置的路径传参占位符： {0} {1} {3}
     * @return 找到对应的api数据权限配置规则组和规则信息并返回
     */
    public static List<SysDprRoleApiDataRuleListQueryDTO> apiPathRoleApiRowsRuleGroupDtoHandle(String[] pathObj
            , SysDprRoleApiRowColumnRuleDTO sysDprRoleApiRowColumnRuleDTO) {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request != null) {
            String menuCode = request.getHeader(DataSecurityConstant.HEADER_MENU_CODE);
            if (menuCode == null) {
                throw new RuntimeException("数据权限需要菜单编码 ，getHeader  menuCode=NULL");
            }

            String requestUrl = request.getRequestURL().toString();
            //重点方法：获取当前用户的角色数据权限信息( app api 规则组，规则 )
            var roelDprDto = sysDprRoleApiRowColumnRuleDTO.getSysDprRoleApiDataRuleListQueryDTO();
            if (roelDprDto == null || roelDprDto.isEmpty()) {
                log.debug("数据权限接口，行规则空。{}", requestUrl);
                return ListUtil.empty();
            }
            //过滤，找到对应API的数据权限。  如果找不到将不会触发数据权限
            var startDto = roelDprDto.stream().filter(dto ->
                            DataPermissionRuleServiceUtil.filterRowAuthApiUrl(dto, request, pathObj))
                    .collect(Collectors.toList());


            startDto = startDto.stream().filter(dto -> dto.getMenusCode().equals(menuCode))
                    .collect(Collectors.toList());

            if (startDto.isEmpty()) {
                log.debug("数据权限接口，当前API没有配置数据权限规则，请开发人员核对，本次将全量查询。{},{}", requestUrl, roelDprDto);
            }
            return startDto;
        } else {
            log.error("数据权限接口，无法获取HttpServletRequest，请确认是否HTTP请求入口。");
            return ListUtil.empty();
        }
    }
}
