/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.dpr.beansearcher;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.MapSearcher;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.CloudBeanSearcherEnum;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.CloudTenantAuthBeanSearcher;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.CloudTenantAuthMapBeanSearcher;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.CloudTenantBeanSearcher;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.CloudTenantMapBeanSearcher;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.provider.TenantClientProvider;

public class BeanSearcherFactory {
    private final BeanSearcher beanSearcher;
    private final MapSearcher mapSearcher;
    private final TenantClientProvider tenantClientProvider;
    private final RoleDataPermissionRuleService dataPermissionRuleService;

    public BeanSearcherFactory(BeanSearcher beanSearcher, MapSearcher mapSearcher, TenantClientProvider tenantClientProvider, RoleDataPermissionRuleService dataPermissionRuleService) {
        this.beanSearcher = beanSearcher;
        this.mapSearcher = mapSearcher;
        this.tenantClientProvider = tenantClientProvider;
        this.dataPermissionRuleService = dataPermissionRuleService;
    }

    public BeanSearcher getBeanSearcherService(CloudBeanSearcherEnum cloudBeanSearcherEnum) {
        if (cloudBeanSearcherEnum == null) {
            throw new RuntimeException("CloudBeanSearcherEnum NULL");
        }
        switch (cloudBeanSearcherEnum) {
            case BS_DEFAULT: {
                return this.beanSearcher;
            }
            case BS_TENANT_AUTH: {
                return new CloudTenantAuthBeanSearcher(this.beanSearcher, this.tenantClientProvider, this.dataPermissionRuleService);
            }
            case BS_TENANT: {
                return new CloudTenantBeanSearcher(this.beanSearcher, this.tenantClientProvider, this.dataPermissionRuleService);
            }
            case BS_AUTH: {
                throw new RuntimeException("\u6682\u672a\u5b9e\u73b0\u53ea\u6570\u636e\u6743\u9650\u4e0d\u79df\u6237");
            }
        }
        throw new RuntimeException("\u679a\u4e3e\u5f02\u5e38");
    }

    public BeanSearcher getBeanSearcherService() {
        return this.beanSearcher;
    }

    public MapSearcher getMapBeanSearcherService() {
        return this.mapSearcher;
    }

    public MapSearcher getMapBeanSearcherService(CloudBeanSearcherEnum cloudBeanSearcherEnum) {
        if (cloudBeanSearcherEnum == null) {
            throw new RuntimeException("CloudMapBeanSearcherEnum NULL");
        }
        switch (cloudBeanSearcherEnum) {
            case BS_DEFAULT: {
                return this.mapSearcher;
            }
            case BS_TENANT_AUTH: {
                return new CloudTenantAuthMapBeanSearcher(this.mapSearcher, this.tenantClientProvider, this.dataPermissionRuleService);
            }
            case BS_TENANT: {
                return new CloudTenantMapBeanSearcher(this.mapSearcher, this.tenantClientProvider, this.dataPermissionRuleService);
            }
            case BS_AUTH: {
                throw new RuntimeException("\u6682\u672a\u5b9e\u73b0\u53ea\u6570\u636e\u6743\u9650\u4e0d\u79df\u6237");
            }
        }
        throw new RuntimeException("\u679a\u4e3e\u5f02\u5e38");
    }
}

