package com.elitescloud.boot.datasecurity.config;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.MapSearcher;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherFactory;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleCacheInterface;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.datasecurity.dpr.service.impl.RoleDataPermissionRuleCacheImpl;
import com.elitescloud.boot.datasecurity.dpr.service.impl.RoleDataPermissionRuleServiceImpl;
import com.elitescloud.boot.datasecurity.jpa.strategy.RoleRuleJpaService;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.system.service.RoleAppApiDataPermissionRpcService;
import org.springframework.context.annotation.Bean;

/**
 * beansearch相关服务类.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/8
 */
public class BeanSearchConfig {

    @Bean
    public RoleDataPermissionRuleCacheInterface roleDataPermissionRuleCacheInterface(RedisUtils redisUtils,
                                                                                     RoleAppApiDataPermissionRpcService roleAppApiDataPermissionRpcService) {
        return new RoleDataPermissionRuleCacheImpl(redisUtils, roleAppApiDataPermissionRpcService);
    }

    @Bean
    public RoleRuleJpaService roleRuleJpaService(RoleDataPermissionRuleService roleDataPermissionRuleService) {
        return new RoleRuleJpaService(roleDataPermissionRuleService);
    }

    @Bean
    public RoleDataPermissionRuleService roleDataPermissionRuleService(RoleDataPermissionRuleCacheInterface roleDataPermissionRuleCacheInterface) {
        return new RoleDataPermissionRuleServiceImpl(roleDataPermissionRuleCacheInterface);
    }

    @Bean
    public BeanSearcherFactory beanSearcherFactory(BeanSearcher beanSearcher,
                                                   MapSearcher mapSearcher,
                                                   TenantClientProvider tenantClientProvider,
                                                   RoleDataPermissionRuleService dataPermissionRuleService) {
        return new BeanSearcherFactory(beanSearcher, mapSearcher, tenantClientProvider, dataPermissionRuleService);
    }
}
