package com.elitescloud.boot.datasecurity.support;

import cn.hutool.core.util.ObjectUtil;
import cn.zhxu.bs.BeanMeta;
import cn.zhxu.bs.FieldMeta;
import cn.zhxu.bs.bean.Cluster;
import cn.zhxu.bs.implement.GroupPairResolver;
import cn.zhxu.bs.param.FieldParam;

/**
 * group by自定义解析器.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/11
 */
public class CloudtGroupPairResolver extends GroupPairResolver {

    @Override
    public boolean isClusterField(BeanMeta<?> beanMeta, FieldParam param, String groupBy) {
        FieldMeta meta = beanMeta.requireFieldMeta(param.getName());
        Cluster cluster = meta.getCluster();
        if (cluster == Cluster.FALSE) {
            return false;
        }
        if (cluster == Cluster.TRUE) {
            return true;
        }
        // 自动推断 是否是 聚合字段
        var fieldSql = ObjectUtil.defaultIfNull(meta.getFieldSql() == null ? "" : meta.getFieldSql().getSql(), "");
        return !meta.getName().equalsIgnoreCase(fieldSql) &&
                fieldSql.contains("(") && fieldSql.contains(")");
    }
}
