/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.dpr.service.util;

import cn.hutool.core.collection.ListUtil;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.datasecurity.dpr.service.util.DataPermissionRuleServiceUtil;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDpcRoleApiFieldsDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleDatePermissionColumnUtil {
    private static final Logger log = LoggerFactory.getLogger(RoleDatePermissionColumnUtil.class);
    public static final String[] GROUP_STR = new String[]{"DPRaa", "DPRbb", "DPRcc", "DPRdd", "DPRee", "DPRff", "DPRgg", "DPRhh", "DPRii", "DPRjj", "DPRkk", "DPRll", "DPRmm", "DPRnn", "DPRoo", "DPRpp", "DPRqq", "DPRrr", "DPRss", "DPRtt", "DPRuu", "DPRvv", "DPRww", "DPRxx", "DPRyy", "DPRzz"};
    public static final String SB_MAP_GROUP_EXPR = MapBuilder.GROUP_EXPR;
    public static final String TENANT_ID_GROUP = "tenantIdGroup";

    public static void setColumnMapBuilder(List<SysDpcRoleApiFieldsDTO> columnDto, MapBuilder mapBuilder) {
        StringBuilder columnOnlStr = new StringBuilder();
        StringBuilder columnExcludeStr = new StringBuilder();
        for (SysDpcRoleApiFieldsDTO dto : columnDto) {
            if (dto.getFieldApiVisible().booleanValue()) {
                if (columnOnlStr.length() == 0) {
                    columnOnlStr.append(dto.getFieldName());
                    continue;
                }
                columnOnlStr.append(",").append(dto.getFieldName());
                continue;
            }
            if (columnExcludeStr.length() == 0) {
                columnExcludeStr.append(dto.getFieldName());
                continue;
            }
            columnExcludeStr.append(",").append(dto.getFieldName());
        }
        if (columnOnlStr.length() != 0) {
            mapBuilder.onlySelect(new String[]{columnOnlStr.toString()});
        }
        if (columnExcludeStr.length() != 0) {
            mapBuilder.selectExclude(new String[]{columnExcludeStr.toString()});
        }
    }

    public static String tenantAuthBuilder(TenantClientProvider tenantClientProvider, MapBuilder mapBuilder, Map<String, Object> params) {
        GeneralUserDetails userInfo = SecurityContextUtil.currentUser();
        Long tenantId = -1L;
        if (tenantClientProvider.enabledTenant()) {
            if (userInfo != null && userInfo.getTenantId() != null) {
                tenantId = userInfo.getTenantId();
            } else {
                SysTenantDTO tenant = tenantClientProvider.getSessionTenant();
                if (tenant != null) {
                    tenantId = tenant.getId();
                }
            }
        }
        mapBuilder.group(TENANT_ID_GROUP);
        ((MapBuilder)mapBuilder.field(BaseModel::getTenantId, new Object[]{tenantId})).op((FieldOp)FieldOps.Equal);
        String bsGroupExpr = RoleDatePermissionColumnUtil.getBeanSearcherGroupExpr(params);
        StringBuffer groupExpr = new StringBuffer();
        if (bsGroupExpr != null && bsGroupExpr.length() > 0) {
            groupExpr.append(bsGroupExpr).append("&tenantIdGroup");
        } else {
            groupExpr.append(TENANT_ID_GROUP);
        }
        return groupExpr.toString();
    }

    public static String tenantBuilder(TenantClientProvider tenantClientProvider, MapBuilder mapBuilder, Map<String, Object> params) {
        GeneralUserDetails userInfo = SecurityContextUtil.currentUser();
        Long tenantId = -1L;
        if (tenantClientProvider.enabledTenant()) {
            if (userInfo != null && userInfo.getTenantId() != null) {
                tenantId = userInfo.getTenantId();
            } else {
                SysTenantDTO tenant = tenantClientProvider.getSessionTenant();
                if (tenant != null) {
                    tenantId = tenant.getId();
                }
            }
        }
        String bsGroupExpr = RoleDatePermissionColumnUtil.getBeanSearcherGroupExpr(params);
        StringBuffer groupExpr = new StringBuffer();
        if (bsGroupExpr != null && bsGroupExpr.length() > 0) {
            mapBuilder.group(TENANT_ID_GROUP);
            ((MapBuilder)mapBuilder.field(BaseModel::getTenantId, new Object[]{tenantId})).op((FieldOp)FieldOps.Equal);
            groupExpr.append(bsGroupExpr).append("&tenantIdGroup");
        } else {
            ((MapBuilder)mapBuilder.field(BaseModel::getTenantId, new Object[]{tenantId})).op((FieldOp)FieldOps.Equal);
            groupExpr.append(TENANT_ID_GROUP);
        }
        return groupExpr.toString();
    }

    public static String getBeanSearcherGroupExpr(Map<String, Object> params) {
        return params.get(SB_MAP_GROUP_EXPR) != null ? params.get(SB_MAP_GROUP_EXPR).toString() : null;
    }

    public static void addSetBeanSearcherGroupExpr(Map<String, Object> params, String groupExpr) {
        Object drpGroupExpr = params.get(SB_MAP_GROUP_EXPR);
        params.put(SB_MAP_GROUP_EXPR, drpGroupExpr + groupExpr);
    }

    public static void jointGroupExpr(int i, int size, SysDprRoleApiDataRuleListQueryDTO rule, String gStr, StringBuilder groupExpr) {
        if (size == 0) {
            return;
        }
        if (i == 0) {
            groupExpr.append("(").append(gStr);
            if (size == 1) {
                groupExpr.append(")");
            }
        } else if (i == size - 1) {
            if (rule.getDprRuleRelation().equals(DprRuleRelationEnum.DPR_RULE_RELATION_OR.name())) {
                groupExpr.append("|").append(gStr).append(")");
            } else if (rule.getDprRuleRelation().equals(DprRuleRelationEnum.DPR_RULE_RELATION_AND.name())) {
                groupExpr.append("&").append(gStr).append(")");
            } else {
                DataPermissionRuleServiceUtil.throwRuntimeException("\u975e\u6cd5\u7684DprRuleRelation \u89c4\u5219\u5173\u7cfb\uff0c\u8bf7\u5c3d\u5feb\u8054\u7cfb\u7ba1\u7406\u5458\u3002\uff1a", rule);
            }
        } else if (rule.getDprRuleRelation().equals(DprRuleRelationEnum.DPR_RULE_RELATION_OR.name())) {
            groupExpr.append("|").append(gStr);
        } else if (rule.getDprRuleRelation().equals(DprRuleRelationEnum.DPR_RULE_RELATION_AND.name())) {
            groupExpr.append("&").append(gStr);
        } else {
            DataPermissionRuleServiceUtil.throwRuntimeException("\u975e\u6cd5\u7684DprRuleRelation \u89c4\u5219\u5173\u7cfb\uff0c\u8bf7\u5c3d\u5feb\u8054\u7cfb\u7ba1\u7406\u5458\u3002\uff1a", rule);
        }
    }

    public static String verificationMenu() {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request != null) {
            String menuCode = request.getHeader("menuCode");
            return menuCode;
        }
        return null;
    }

    public static List<SysDprRoleApiDataRuleListQueryDTO> apiPathRoleApiRowsRuleGroupDtoHandle(String[] pathObj, SysDprRoleApiRowColumnRuleDTO sysDprRoleApiRowColumnRuleDTO) {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request != null) {
            String menuCode = RoleDatePermissionColumnUtil.verificationMenu();
            if (menuCode == null) {
                throw new RuntimeException("\u6570\u636e\u6743\u9650\u9700\u8981\u83dc\u5355\u7f16\u7801 \uff0cgetHeader  menuCode=NULL");
            }
            String requestUrl = request.getRequestURL().toString();
            List roelDprDto = sysDprRoleApiRowColumnRuleDTO.getSysDprRoleApiDataRuleListQueryDTO();
            if (roelDprDto == null || roelDprDto.isEmpty()) {
                log.debug("\u6570\u636e\u6743\u9650\u63a5\u53e3\uff0c\u884c\u89c4\u5219\u7a7a\u3002{}", (Object)requestUrl);
                return ListUtil.empty();
            }
            List<SysDprRoleApiDataRuleListQueryDTO> startDto = roelDprDto.stream().filter(dto -> DataPermissionRuleServiceUtil.filterRowAuthApiUrl(dto, request, pathObj)).collect(Collectors.toList());
            if ((startDto = startDto.stream().filter(dto -> dto.getMenusCode().equals(menuCode)).collect(Collectors.toList())).isEmpty()) {
                log.debug("\u6570\u636e\u6743\u9650\u63a5\u53e3\uff0c\u5f53\u524dAPI\u6ca1\u6709\u914d\u7f6e\u6570\u636e\u6743\u9650\u89c4\u5219\uff0c\u8bf7\u5f00\u53d1\u4eba\u5458\u6838\u5bf9\uff0c\u672c\u6b21\u5c06\u5168\u91cf\u67e5\u8be2\u3002{},{}", (Object)requestUrl, (Object)roelDprDto);
            }
            return startDto;
        }
        log.error("\u6570\u636e\u6743\u9650\u63a5\u53e3\uff0c\u65e0\u6cd5\u83b7\u53d6HttpServletRequest\uff0c\u8bf7\u786e\u8ba4\u662f\u5426HTTP\u8bf7\u6c42\u5165\u53e3\u3002");
        return ListUtil.empty();
    }
}

