/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.core.security.util;

import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DataSecurityJpaUtil {
    private static boolean dataPermissionEnable = false;
    private static final String ROUTE_KEY = "RouteKey";

    static void setDataPermissionEnable(boolean dataPermissionEnable) {
        DataSecurityJpaUtil.dataPermissionEnable = dataPermissionEnable;
    }

    public static Predicate dataAuthJpaPredicate(PathMetadata metadata) {
        String route;
        QBaseModel qBaseModel;
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        Predicate predicate = DataSecurityJpaUtil.preCheck(user, qBaseModel = new QBaseModel(metadata), route = DataSecurityJpaUtil.getRequestSysDataRoute());
        if (predicate != null) {
            return predicate;
        }
        return null;
    }

    private static String getRequestSysDataRoute() {
        if (RequestContextHolder.getRequestAttributes() == null) {
            return null;
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        return request.getHeader(ROUTE_KEY);
    }

    private static Predicate preCheck(GeneralUserDetails user, QBaseModel qBaseModel, String route) {
        if (!dataPermissionEnable) {
            return Expressions.booleanTemplate((String)"1=1", (Object[])new Object[0]);
        }
        if (user == null || user.getUser() == null) {
            return Expressions.booleanTemplate((String)"1=1", (Object[])new Object[0]);
        }
        if (user.isSystemAdmin() || user.isTenantAdmin()) {
            return Expressions.booleanTemplate((String)"1=1", (Object[])new Object[0]);
        }
        return null;
    }
}

