package com.elitescloud.boot.datasecurity.dataauth.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.constant.IdGeneratorStrategy;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

/**
 * 组织树明细
 *
 * @author Tristan
 * @date 2020/7/2
 * @deprecated 用于1.0的数据权限，已遗弃
 */
//@Entity
@Table(name = "common_org_bu_treed", indexes = {
        @Index(name = "idx_bu_tree_pid", columnList = "pid"),
        @Index(name = "idx_bu_tree_code_path", columnList = "codePath")
})
@org.hibernate.annotations.Table(appliesTo = "common_org_bu_treed", comment = "组织树明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "组织树明细", description = "组织树明细")
@Deprecated(forRemoval = true, since = "3.1.0")
public class SecOrgBuTreedDO implements Serializable {


    private static final long serialVersionUID = 962273096140553301L;

    @Id
    @GenericGenerator(name = "el-id", strategy = IdGeneratorStrategy.DEFAULT)
    @GeneratedValue(strategy = GenerationType.AUTO, generator = "el-id")
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    @Comment("记录唯一ID")
    @Column()
    private Long id;

    /**
     * 上级ID
     */
    @ApiModelProperty(value = "上级ID")
    @Comment("上级ID")
    @Column()
    private Long pid = 0L;

    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号")
    @Comment("排序号")
    @Column()
    private Integer sortNo;

    /**
     * 层级
     */
    @ApiModelProperty(value = "层级")
    @Comment("层级")
    @Column()
    private Integer level = 1;

    /**
     * 树型结构编号全路径，使用/隔离
     */
    @ApiModelProperty("树型结构编号全路径，使用/隔离")
    @Comment("树型结构编号全路径，使用/隔离")
    @Column()
    private String codePath;

    /**
     * 组织树ID
     */
    @ApiModelProperty(value = "组织树ID")
    @Comment("组织树ID")
    @Column
    private Long buTreeId;

    /**
     * 组织ID
     */
    @ApiModelProperty(value = "组织ID")
    @Comment("组织ID")
    @Column
    private Long buId;

    /**
     * 组织编号
     */
    @ApiModelProperty(value = "组织编号")
    @Comment("记录唯一ID")
    @Column()
    private String buCode;

    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    @Comment("逻辑删除，0：未删除，1：已删除")
    @Column
    private Integer deleteFlag;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecOrgBuTreedDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecOrgBuTreedDO entity = (SecOrgBuTreedDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
