package com.elitescloud.boot.datasecurity.dpr.service.util;

import cn.hutool.core.util.ArrayUtil;
import cn.zhxu.bs.util.MapBuilder;
import com.elitescloud.boot.datasecurity.common.DataSecurityConstant;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.cloudt.system.dto.SysDpcRoleApiFieldsDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.google.gson.Gson;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

/**
 * @author : chen
 * 工具类
 * @date 2022-11-30 15:01
 */
public class DataPermissionRuleServiceUtil {


    /**
     * @param @param null
     * @return
     * @description 异常处理。
     */
    public static void throwRuntimeException(String msg, SysDprRoleApiDataRuleListQueryDTO rule) {
        Gson gson = new Gson();
        var data = gson.toJson(rule);
        throw new RuntimeException("数据权限异常：" + msg + data);

    }

    /**
     * @param @param null
     * @return
     * @description 校验是否不是有对应的BS枚举。
     */
    private static String ruleConditionCheckBeanSearcherOp(String dprRuleCondition) {
        if (DprRuleConditionEnum.getValue(dprRuleCondition) != null) {
            return dprRuleCondition;
        } else {
            throw new RuntimeException("非法的运算符设置，请尽快联系管理员。：" + dprRuleCondition);
        }

    }

    /**
     * @param @param  null
     * @param pathObj
     * @return
     * @description 过滤行权限的APIUrl路径的判断方法
     */
    public static boolean filterRowAuthApiUrl(@NotNull SysDprRoleApiDataRuleListQueryDTO dto, @NotNull HttpServletRequest request, String[] pathObj) {
        var permissionRuleInfo = new PermissionRuleInfo(dto.getApiPermissionCode(), dto.getApiPermissionPath(), dto.getApiPermissionRequestType());
        return isMatchApi(permissionRuleInfo, request, pathObj);

    }

    /**
     * @param @param  null
     * @param pathObj
     * @return
     * @description 过滤列权限的APIUrl路径的判断方法
     */
    public static boolean filterColumnAuthApiUrl(@NotNull SysDpcRoleApiFieldsDTO dto, @NotNull HttpServletRequest request, String[] pathObj) {
        var permissionRuleInfo = new PermissionRuleInfo(dto.getApiPermissionCode(), dto.getApiPermissionPath(), dto.getApiPermissionRequestType());
        return isMatchApi(permissionRuleInfo, request, pathObj);
    }

    /**
     * 是否匹配路径
     *
     * @param apiPermission 权限规则
     * @param request       请求
     * @param pathObj       路径参数
     * @return 是否匹配
     */
    private static boolean isMatchApi(@NotNull PermissionRuleInfo apiPermission,
                                      @NotNull HttpServletRequest request, String[] pathObj) {
        // 优先根据接口编码匹配
        var apiCode = request.getHeader(DataSecurityConstant.HEADER_API_CODE);
        if (StringUtils.hasText(apiCode)) {
            return Objects.equals(apiPermission.getApiCode(), apiCode);
        }

        // 其次根据接口匹配
        if (!request.getMethod().equalsIgnoreCase(apiPermission.getMethod())) {
            // 请求方式不匹配
            return false;
        }
        //优先获取路径参数，主要用于模板导出，可以统一传参模板编码，这样不需要每个开发在调用的时候传递参数。
        String[] pathObjAttribute= (String[]) request.getAttribute("pathObj");
        if(!ArrayUtil.isEmpty(pathObjAttribute)){
            var apiPathFormat = MessageFormat.format(apiPermission.getPath(),pathObjAttribute);
            return Objects.equals(request.getServletPath(), apiPathFormat);
        }
            //各调用获取路径参数，此方法目前使用较少。
        if (ArrayUtil.isEmpty(pathObj)) {
            //如果没有传递参数全路径匹配
            return Objects.equals(request.getServletPath(), apiPermission.getPath());
        }else{
            return Objects.equals(request.getServletPath(), pathObj);
        }


    }


    //判断api地址
    private static boolean isApiPath(String apiPath, String requestUrl, String[] pathObj) {
        if (pathObj == null || pathObj.length == 0) {
            return apiPath.equals(requestUrl);
        } else {
            var apiPathFormat = MessageFormat.format(apiPath, pathObj);
            return apiPathFormat.equals(requestUrl);
        }
    }

    /****根据规则条件类型枚举，采用bs构造器构造查询条件和参数****/
    public static void dprRuleValueTypeMapBuilder(MapBuilder mapBuilder, SysDprRoleApiDataRuleListQueryDTO rule) {
        String valueType = rule.getDprRuleValueType();
        String value = rule.getDprRuleValue();
        String ruleCondition = rule.getDprRuleCondition();
        switch (DprRuleConditionEnum.valueOf(ruleCondition)) {
            //"等于", 1
            case Equal:
                //"结束like%xxx", 13
            case EndWith:
                //"以..开始like'xxx%'", 12
            case StartWith:
                //"包含Like%xxx%", 11
            case Contain:
                //"小于", 6
            case LessThan:
                //"小于等于", 5
            case LessEqual:
                //"大于", 4
            case GreaterThan:
                //"大于等于", 3
            case GreaterEqual:
                //"不等", 2
            case NotEqual:
                mapBuilderFieldValueOne(mapBuilder, value, rule);
                break;

            //"在和之间", 14
            case Between:
                //"不在..和..之间", 15
            case NotBetween:
                mapBuilderFieldValueTwo(mapBuilder, value, rule);
                break;

            //" 在列表中in", 16
            case InList:
                //"不在某个集合内notin", 17
            case NotIn:
                mapBuilderFieldValueMulti(mapBuilder, value, rule);
                break;
            default:
                DataPermissionRuleServiceUtil.throwRuntimeException("非法的运算符设置，请尽快联系管理员。：", rule);


        }
    }

    /**
     * @param @param null
     * @return
     * @description 字段设置值和规则， 多值
     */
    private static void mapBuilderFieldValueMulti(MapBuilder mapBuilder, String value, SysDprRoleApiDataRuleListQueryDTO rule) {
        String[] values = value.split(",");
        if (values.length == 0) {
            throwRuntimeException("错误的规则值参数，请尽快联系管理员。：", rule);
        }
        ArrayList<String> stringList = new ArrayList<>(values.length);
        Collections.addAll(stringList, values);
        mapBuilder.field(rule.getDprRuleField(), stringList).op(rule.getDprRuleCondition());
    }

    /**
     * @param @param null
     * @return
     * @description 字段设置值和规则， 只有一个值
     */
    private static void mapBuilderFieldValueOne(MapBuilder mapBuilder, String value, SysDprRoleApiDataRuleListQueryDTO rule) {
        mapBuilder.field(rule.getDprRuleField(), value).op(rule.getDprRuleCondition());
    }

    /**
     * @param @param null
     * @return
     * @description 字段设置值和规则， 只有二个值
     */
    private static void mapBuilderFieldValueTwo(MapBuilder mapBuilder, String value, SysDprRoleApiDataRuleListQueryDTO rule) {
        String[] values = value.split(",");
        if (values.length <= 1) {
            throwRuntimeException("错误的规则值参数，请尽快联系管理员。：", rule);
        }
        ArrayList<String> stringList = new ArrayList<>(values.length);
        Collections.addAll(stringList, values);
        mapBuilder.field(rule.getDprRuleField(), stringList).op(rule.getDprRuleCondition());
    }

    @AllArgsConstructor
    @Getter
    private static class PermissionRuleInfo {
        private String apiCode;
        private String path;
        private String method;
    }


}
