package com.elitescloud.boot.datasecurity.dpr.service.util;

import cn.hutool.core.collection.ListUtil;
import com.elitescloud.boot.datasecurity.common.DataSecurityConstant;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.system.dto.SysDpcRoleApiFieldsDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/3/29 17:29
 */
@Slf4j
public class RoleDatePermissionRowUtil {


    public static List<SysDpcRoleApiFieldsDTO> apiPathRoleApiColumnRuleGroupDtoHandle(String[] pathObj
            , SysDprRoleApiRowColumnRuleDTO sysDprRoleApiRowColumnRuleDTO) {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request != null) {
            String menuCode=request.getHeader(DataSecurityConstant.HEADER_MENU_CODE);
            if(menuCode==null){
                throw new RuntimeException("数据权限需要菜单编码 ，getHeader  menuCode=NULL");
            }
            String requestUrl = request.getRequestURL().toString();
            //重点方法：获取当前用户的角色数据权限信息( app api 规则组，规则 )
            var roelDprDto = sysDprRoleApiRowColumnRuleDTO.getSysDpcRoleApiFieldsDTOList();
            //过滤，找到对应API的数据权限。  如果找不到将不会触发数据权限
            var startDto = roelDprDto.stream().filter(dto ->
                            DataPermissionRuleServiceUtil.filterColumnAuthApiUrl(dto, request, pathObj))
                    .collect(Collectors.toList());
            startDto= startDto.stream().filter(dto ->dto.getMenusCode().equals(menuCode))
                    .collect(Collectors.toList());
            if (startDto.isEmpty()) {
                log.debug("数据权限接口，当前API没有配置列数据权限规则，。{},{}", requestUrl, roelDprDto);
            }
            return startDto;
        } else {
            log.error("数据权限接口，无法获取HttpServletRequest，请确认是否HTTP请求入口。");
            return ListUtil.empty();
        }
    }
}
