package com.elitescloud.boot.datasecurity.jpa.strategy;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.datasecurity.common.DataSecurityConstant;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.datasecurity.dpr.service.util.RoleDatePermissionColumnUtil;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author : chen.niu
 * @description : 数据权限JPA应用的接口
 * @date : 2023/10/14 18:46
 */
@Slf4j
public class RoleRuleJpaService {
    private final RoleDataPermissionRuleService roleDataPermissionRuleService;

    public RoleRuleJpaService(RoleDataPermissionRuleService roleDataPermissionRuleService) {
        this.roleDataPermissionRuleService = roleDataPermissionRuleService;
    }

    /***
     * 获取当前用户的全部角色数据权限配置
     * **/
    public SysDprRoleApiRowColumnRuleDTO getUserRoleDpr() {
        return roleDataPermissionRuleService.getUserRoleDpr();
    }


    /***
     * 返回当前用户的访问的API的菜单的角色权限的JPA Predicate条件
     * 如果菜单编码为空将会抛异常，强制要求前端传递过来。
     * @param entityClass jpa实体类
     * @param alias jpa sql查询表的别名，如果没有其就是jpa实体类的首字母小写名称 如SysUser 应该是sysUser
     * **/
    public Predicate getUserRoleApiMenusAuthJpaPredicate(Class entityClass, String alias) {
        var userRoleDpr = roleDataPermissionRuleService.getUserRoleDpr();
        if(userRoleDpr==null || CollUtil.isEmpty(userRoleDpr.getSysDprRoleApiDataRuleListQueryDTO())){
            log.info("没有找到当前用户数据权限配置-跳过数据权限");
            return new BooleanBuilder(null);
        }
        //行数据权限配置 根据请求的path路径  比对当前用户全部的api行数据权限配置。 找到对应的api数据权限配置规则组和规则信息并返回
        List<SysDprRoleApiDataRuleListQueryDTO> startDto =
                RoleDatePermissionColumnUtil.apiPathRoleApiRowsRuleGroupDtoHandle(null, userRoleDpr);
        if(CollUtil.isEmpty(startDto)){
            log.info("没有找到当前用户数据权限配置匹配规则-跳过数据权限");
            return new BooleanBuilder(null);
        }

        //queryDsl动态构造
        PathBuilder entityPath = new PathBuilder<>(entityClass, alias);
        if (startDto != null && !startDto.isEmpty()) {
            BooleanBuilder group1 = new BooleanBuilder();
            for (SysDprRoleApiDataRuleListQueryDTO sysRule : startDto) {
                var predicateRule = RuleStrategyManager.getPathAutomatically(entityPath, sysRule);
//                predicate.ann;
                group1.and(predicateRule);
            }
            return group1;
        }
        return new BooleanBuilder(null);
    }

    /***
     * 返回当前用户的访问的API的菜单的角色权限的JPA Predicate条件
     *  这个方法菜单编码可以为空，如果空跳过权限。主要用于不好判断是否一定前端请求的接口，有的接口可能前端数据权限调用或采用定时任务或MQ消费复用的情况。
     * @param entityClass jpa实体类
     * @param alias jpa sql查询表的别名，如果没有其就是jpa实体类的首字母小写名称 如SysUser 应该是sysUser
     * **/
    public Predicate getUserRoleApiMenusAuthJpaPredicateMenusCodeEmpty(Class<?> entityClass, String alias) {
        try {
            String menuCode = RoleDatePermissionColumnUtil.verificationMenu();
            if (menuCode == null) {
                log.info("数据权限需要菜单编码将跳过数据权限，getHeader  menuCode=NULL");
                return new BooleanBuilder(null);
            } else {
                return getUserRoleApiMenusAuthJpaPredicate(entityClass, alias);
            }
        } catch (Exception e) {
            log.error("JPA权限异常，异常需要分析，暂跳过权限功能：" + e.getMessage());
            return new BooleanBuilder(null);
        }

    }

    /***
     * 返回当前用户的访问的API的菜单的角色权限的JPA Predicate条件
     *  这个方法菜单编码可以为空，如果空跳过权限。主要用于不好判断是否一定前端请求的接口，有的接口可能前端数据权限调用或采用定时任务或MQ消费复用的情况。
     * jpa sql查询表的别名，如果没有其就是jpa实体类的首字母小写名称 如SysUser 应该是sysUser
     *
     * @param entityClass jpa实体类
     * @
     * **/
    public Predicate getUserRoleApiMenusAuthJpaPredicateMenusCodeEmpty(Class<?> entityClass) {
        try {
            String menuCode = RoleDatePermissionColumnUtil.verificationMenu();
            if (menuCode == null) {
                log.info("数据权限需要菜单编码将跳过数据权限，getHeader  menuCode=NULL");
                return new BooleanBuilder(null);
            } else {
                //如果没有别名，使用JPA默认规范，DO Class名称，首字母小写。
                var classAlias=entityClass.getSimpleName().substring(0, 1).toLowerCase()
                        + entityClass.getSimpleName().substring(1);
                return getUserRoleApiMenusAuthJpaPredicate(entityClass, classAlias);
            }
        } catch (Exception e) {
            log.error("JPA权限异常，异常需要分析，暂跳过权限功能：" + e.getMessage());
            return new BooleanBuilder(null);
        }

    }



}