package com.elitescloud.boot.datasecurity.util;

import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/10/13 22:17
 */
public class DataSecurityJpaUtil {

    /**
     * 决定是否开启数据权限
     */
    private static boolean dataPermissionEnable = false;
    static void setDataPermissionEnable(boolean dataPermissionEnable) {
        DataSecurityJpaUtil.dataPermissionEnable = dataPermissionEnable;
    }
    /**
     * 存储前端传递的应用name
     */
    private static final String ROUTE_KEY = "RouteKey";

    /**
     * 集成了架构用户权限获取和 spring http request请求方法
     * 1.获取当前登录用户数据权限信息。 数据权限角色，角色中的权限配置
     * 2.获取当前请求前端应用通过request中header传递的应用名称。
     * 3.运算多个数据角色中的数据配置和应用配置，算出最终的数据权限对象。 包括：组织授权集合，用户授权集合
     * 4.   QueryDsl Predicate查询条件对象。 回给业务开发
     *
     * @param metadata 表元数据信息 以那个表维度增加条件
     * @return predicate   查询条件
     */
    public static Predicate dataAuthJpaPredicate(PathMetadata metadata) {

        // ======== 1. 获取当前用户信息包括各种权限对象。 ========
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        // ======== 2. 获取 BaseModel ========
        var qBaseModel = new QBaseModel(metadata);
        // ======== 3. 获取应用名 ========
        String route = getRequestSysDataRoute();

        // ======== 4. 校验 ========
        var predicate = preCheck(user, qBaseModel, route);
        if (predicate != null) {
            return predicate;
        }
        return null;

    }


    /**
     * 私有方法 获取前端应用传递来的应用名称
     *
     * @return route 编号
     */
    private static String getRequestSysDataRoute() {
        if (RequestContextHolder.getRequestAttributes() == null) {
            return null;
        } else {
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();

            return request.getHeader(ROUTE_KEY);
        }
    }


    /**
     * 前置校验，决定是否需要进行数据权限过滤
     *
     * @param user       当前登录人信息
     * @param qBaseModel 表
     * @param route      当前应用
     * @return where 条件
     */
    private static Predicate preCheck(GeneralUserDetails user, QBaseModel qBaseModel, String route) {


        // ======== 前置校验，校验放在所有动作之前，保证效率 ========
        if (!dataPermissionEnable) {
            // 1 如果没有启用数据权限控制，则直接返回一个必然为 true 的判断
            // return qBaseModel.id.isNotNull();
            //  return Expressions.booleanTemplate("1=1");
            return Expressions.booleanTemplate("1=1");

//        } else if (StringUtils.isBlank(route)) {
//            // 2 如果应用编号为空，则抛出异常
//            throw new BusinessException(ApiCode.FAIL, "数据权限异常，RouteKey 为空");

        } else if (user == null || user.getUser() == null) {
            // 3 如果用户信息为空，则说明是匿名用户，则直接返回一个必然为 true 的判断
            // 匿名用户需要返回所有数据，否则 swagger 将无法调试
            //   return qBaseModel.id.isNotNull();
            // return Expressions.asBoolean(true).isTrue();
            return Expressions.booleanTemplate("1=1");

        } else if (user.isSystemAdmin() || user.isTenantAdmin()) {
            // return qBaseModel.id.isNotNull();
            // return Expressions.asBoolean(true).isTrue();
            return Expressions.booleanTemplate("1=1");

        } else {
            // 校验通过，返回 null
//            var authScope = sysDataRoleOperation(user, route, false);
//
//            return buildIdInPredicate(qBaseModel, user, authScope);
        }
        return null;
    }


}
