package com.elitescloud.cloudt.core.security.dataauth.metadata;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimePath;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * <p>
 * 日期类型的谓词处理
 * </p >
 *
 * @author niu.chen
 * @date 2021-09-07
 */
public class MateDataJpaTypeDate implements BaseMateDataJpaInterface {


    @Override
    @Deprecated
    public Predicate mateDataPredicateJpaIn(MateDataPredicateParam mateDataPredicateParam) {
        return null;
    }

    @Override
    public Predicate mateDataPredicateJpaEq(MateDataPredicateParam mateDataPredicateParam) {
        String fieldValue = mateDataPredicateParam.getFieldValue();
        String[] strArray = DataAuthBusinessJpaUtil.splitFieldValue(fieldValue);
        if (strArray == null || strArray.length == 0) {
            return null;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDateTime ldt = LocalDateTime.parse(strArray[0] + " 00:00:00", df);
        LocalDateTime ldt2 = LocalDateTime.parse(strArray[0] + " 59:59:59", df);
        DateTimePath<LocalDateTime> stringPath =
                new JpaMetadataUtil(mateDataPredicateParam.getMetadata())
                        .createTimeField(mateDataPredicateParam.getFieldCode(), LocalDateTime.class);
        return stringPath.between(ldt, ldt2);
    }

    @Override
    @Deprecated
    public Predicate mateDataPredicateJpaContains(MateDataPredicateParam mateDataPredicateParam) {
        return null;
    }

    @Override
    @Deprecated
    public Predicate mateDataPredicateJpaBetween(MateDataPredicateParam mateDataPredicateParam) {

        return null;
    }
}
