package com.elitescloud.cloudt.core.security.dataauth.metadata;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Accessors;
import lombok.val;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * REST  返回结果
 * </p>
 *
 * @author nc
 * @date 2021-11-08
 */
@Data
@Accessors(chain = true)
@Builder
@AllArgsConstructor
public class DataAuthResult<T> implements Serializable {


    private static final long serialVersionUID = -2726880634686362948L;
    /**
     * 响应消息
     */
    private String msg;

    /**
     * 错误信息
     */
    private String errorMsg;

    /**
     * 是否成功
     */
    private boolean success;

    /**
     * 响应数据
     */
    private T data;


    public DataAuthResult() {

    }

    public static <T> DataAuthResult<T> result(boolean flag) {
        if (flag) {
            return ok();
        }
        return fail();
    }

    public static <T> DataAuthResult<T> result(DateAuthResultCode authResultCode) {
        return result(authResultCode, null);
    }

    public static <T> DataAuthResult<T> result(DateAuthResultCode authResultCode, T data) {
        return result(authResultCode, null, data);
    }

    public static <T> DataAuthResult<T> result(DateAuthResultCode authResultCode, String msg, T data) {
        var success = authResultCode == DateAuthResultCode.SUCCESS;

        return DataAuthResult.<T>builder()
                .msg(msg)
                .errorMsg(authResultCode.getMsg())
                .data(data)
                .success(success)
                .build();
    }

    public static <T> DataAuthResult<T> ok() {
        return ok(null);
    }

    public static <T> DataAuthResult<T> ok(T data) {
        return result(DateAuthResultCode.SUCCESS, data);
    }

    public static <T> DataAuthResult<T> ok(T data, String msg) {
        return result(DateAuthResultCode.SUCCESS, msg, data);
    }

    public static <T> DataAuthResult<Map<String, T>> okMap(String key, T value) {
        Map<String, T> map = new HashMap<>(1);
        map.put(key, value);
        return ok(map);
    }

    public static Map<String, Object> toMap(DataAuthResult<?> result) {
        val map = new HashMap<String, Object>();

        map.put("msg", result.msg);
        map.put("data", result.data);
        map.put("success", result.success);

        return map;
    }

    public static <T> DataAuthResult<T> fail(DateAuthResultCode authResultCode) {
        return result(authResultCode, null);
    }

    public static <T> DataAuthResult<T> fail(String msg) {
        return result(DateAuthResultCode.FAIL, msg, null);
    }

    public static DataAuthResult<Object> fail(DateAuthResultCode authResultCode, String msg) {
        if (DateAuthResultCode.SUCCESS == authResultCode) {
            throw new IllegalArgumentException("失败结果状态码不能为" + DateAuthResultCode.SUCCESS.getCode());
        }
        return result(authResultCode, msg, null);
    }

    public static <T> DataAuthResult<T> fail(DateAuthResultCode authResultCode, T data) {
        if (DateAuthResultCode.SUCCESS == authResultCode) {
            throw new IllegalArgumentException("失败结果状态码不能为" + DateAuthResultCode.SUCCESS.getCode());
        }
        return result(authResultCode, data);
    }

    public static <T> DataAuthResult<T> fail(DateAuthResultCode authResultCode, T data, String msg) {
        if (DateAuthResultCode.SUCCESS == authResultCode) {
            throw new IllegalArgumentException("失败结果状态码不能为" + DateAuthResultCode.SUCCESS.getCode());
        }
        return result(authResultCode, msg, data);
    }

    public static <T> DataAuthResult<Map<String, T>> fail(String key, T value) {
        Map<String, T> map = new HashMap<>(1);
        map.put(key, value);
        return result(DateAuthResultCode.FAIL, map);
    }

    public static <T> DataAuthResult<T> fail() {
        return fail(DateAuthResultCode.FAIL);
    }
}