/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.support;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.datasecurity.dpr.service.util.RoleDatePermissionColumnUtil;
import com.elitescloud.boot.filter.UdcFilter;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import com.elitescloud.cloudt.system.dto.SysUdcDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSecurityUdcFilter
implements UdcFilter {
    private static final Logger log = LoggerFactory.getLogger(DataSecurityUdcFilter.class);
    private final RoleDataPermissionRuleService roleDataPermissionRuleService;

    public DataSecurityUdcFilter(RoleDataPermissionRuleService roleDataPermissionRuleService) {
        this.roleDataPermissionRuleService = roleDataPermissionRuleService;
    }

    public void doFilter(List<SysUdcDTO> udcList) {
        if (RoleDatePermissionColumnUtil.verificationMenu() == null) {
            return;
        }
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null || CollUtil.isEmpty((Collection)user.getUser().getRoles())) {
            return;
        }
        Map<String, List<SysUdcDTO>> udcListMap = this.filterUdc(udcList);
        if (udcListMap.isEmpty()) {
            return;
        }
        List<FilteredUdc> authUdcValueList = this.obtainAuthedUdcValue();
        if (authUdcValueList.isEmpty()) {
            return;
        }
        Map<String, List<FilteredUdc>> udcValuesMap = authUdcValueList.stream().collect(Collectors.groupingBy(t -> t.getAppCode() + ":" + t.getUdcCode()));
        if (log.isDebugEnabled()) {
            log.debug("\u53ef\u8fc7\u6ee4\u7684UDC\uff1a{}", (Object)String.join((CharSequence)", ", udcValuesMap.keySet()));
        }
        List<FilteredUdc> filteredValueList = null;
        List resultValueList = null;
        for (SysUdcDTO udcDTO : udcList) {
            filteredValueList = udcValuesMap.get(udcDTO.getAppCode() + ":" + udcDTO.getUdcCode());
            if (filteredValueList == null) continue;
            HashSet<String> includeValues = new HashSet<String>();
            HashSet<String> excludeValues = new HashSet<String>();
            for (FilteredUdc filteredUdc : filteredValueList) {
                if (CollUtil.isNotEmpty(filteredUdc.getUdcValueInclude())) {
                    includeValues.addAll(filteredUdc.getUdcValueInclude());
                }
                if (!CollUtil.isNotEmpty(filteredUdc.getUdcValueExclude())) continue;
                excludeValues.addAll(filteredUdc.getUdcValueExclude());
            }
            resultValueList = udcDTO.getValueList().stream().filter(t -> {
                if (!excludeValues.isEmpty()) {
                    return includeValues.isEmpty() ? !excludeValues.contains(t.getUdcValueCode()) : !excludeValues.contains(t.getUdcValueCode()) && includeValues.contains(t.getUdcValueCode());
                }
                if (!includeValues.isEmpty()) {
                    return includeValues.contains(t.getUdcValueCode());
                }
                return true;
            }).collect(Collectors.toList());
            udcDTO.setValueList(resultValueList);
        }
    }

    private Map<String, List<SysUdcDTO>> filterUdc(List<SysUdcDTO> udcList) {
        if (CollUtil.isEmpty(udcList)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<SysUdcDTO>> udcListMap = new HashMap<String, List<SysUdcDTO>>(udcList.size());
        for (SysUdcDTO udcDTO : udcList) {
            if (udcDTO == null || CollUtil.isEmpty((Collection)udcDTO.getValueList())) continue;
            udcListMap.computeIfAbsent(udcDTO.getUdcCode(), k -> new ArrayList(4)).add(udcDTO);
        }
        return udcListMap;
    }

    private List<FilteredUdc> obtainAuthedUdcValue() {
        SysDprRoleApiRowColumnRuleDTO userRoleDpr = this.roleDataPermissionRuleService.getUserRoleDpr();
        if (userRoleDpr == null || CollUtil.isEmpty((Collection)userRoleDpr.getSysDprRoleApiDataRuleListQueryDTO())) {
            return Collections.emptyList();
        }
        List<SysDprRoleApiDataRuleListQueryDTO> startDto = RoleDatePermissionColumnUtil.apiPathRoleApiRowsRuleGroupDtoHandle(null, userRoleDpr);
        if (CollUtil.isEmpty(startDto)) {
            return Collections.emptyList();
        }
        return startDto.stream().filter(t -> DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_BUSINESS.name().equals(t.getRoleRuleValueType()) && "UDC".equals(t.getDataSet()) && CharSequenceUtil.isAllNotBlank((CharSequence[])new CharSequence[]{t.getDprRuleValue(), t.getBs1(), t.getBs2()})).map(t -> {
            FilteredUdc filteredUdc = new FilteredUdc();
            filteredUdc.setAppCode(t.getBs1());
            filteredUdc.setUdcCode(t.getBs2());
            List<String> values = Arrays.asList(t.getDprRuleValue().split(","));
            if (DprRuleConditionEnum.Equal.name().equals(t.getDprRuleCondition()) || DprRuleConditionEnum.InList.name().equals(t.getDprRuleCondition())) {
                filteredUdc.setUdcValueInclude(values);
                filteredUdc.setUdcValueExclude(Collections.emptyList());
            } else if (DprRuleConditionEnum.NotEqual.name().equals(t.getDprRuleCondition()) || DprRuleConditionEnum.NotIn.name().equals(t.getDprRuleCondition())) {
                filteredUdc.setUdcValueInclude(Collections.emptyList());
                filteredUdc.setUdcValueExclude(values);
            }
            return filteredUdc;
        }).collect(Collectors.toList());
    }

    static class FilteredUdc {
        private String appCode;
        private String udcCode;
        private List<String> udcValueInclude;
        private List<String> udcValueExclude;

        FilteredUdc() {
        }

        public String getAppCode() {
            return this.appCode;
        }

        public void setAppCode(String appCode) {
            this.appCode = appCode;
        }

        public String getUdcCode() {
            return this.udcCode;
        }

        public void setUdcCode(String udcCode) {
            this.udcCode = udcCode;
        }

        public List<String> getUdcValueInclude() {
            return this.udcValueInclude;
        }

        public void setUdcValueInclude(List<String> udcValueInclude) {
            this.udcValueInclude = udcValueInclude;
        }

        public List<String> getUdcValueExclude() {
            return this.udcValueExclude;
        }

        public void setUdcValueExclude(List<String> udcValueExclude) {
            this.udcValueExclude = udcValueExclude;
        }
    }
}

