package com.elitescloud.boot.datasecurity;

import com.elitescloud.boot.datasecurity.config.DataSecurityBeanSearchConfig;
import com.elitescloud.boot.datasecurity.config.DataSecurityJpaConfig;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleCacheInterface;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.datasecurity.dpr.service.impl.RoleDataPermissionRuleCacheImpl;
import com.elitescloud.boot.datasecurity.dpr.service.impl.RoleDataPermissionRuleServiceImpl;
import com.elitescloud.boot.datasecurity.support.DataSecurityUdcFilter;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.system.service.RoleAppApiDataPermissionRpcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

/**
 * 数据安全自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 3/17/2023
 */
@Import({
        DataSecurityJpaConfig.class, DataSecurityBeanSearchConfig.class
})
@Slf4j
class CloudtDataSecurityAutoConfiguration {

    @Bean
    public RoleDataPermissionRuleCacheInterface roleDataPermissionRuleCacheInterface(RedisUtils redisUtils,
                                                                                     RoleAppApiDataPermissionRpcService roleAppApiDataPermissionRpcService) {
        return new RoleDataPermissionRuleCacheImpl(redisUtils, roleAppApiDataPermissionRpcService);
    }

    @Bean
    public RoleDataPermissionRuleService roleDataPermissionRuleService(RoleDataPermissionRuleCacheInterface roleDataPermissionRuleCacheInterface) {
        return new RoleDataPermissionRuleServiceImpl(roleDataPermissionRuleCacheInterface);
    }

    @Bean
    @ConditionalOnProperty(prefix = "elitesland.data-security.udc", name = "enabled", havingValue = "true")
    public DataSecurityUdcFilter dataSecurityUdcFilter(RoleDataPermissionRuleService roleDataPermissionRuleService) {
        log.info("启用数据权限过滤UDC");
        return new DataSecurityUdcFilter(roleDataPermissionRuleService);
    }
}
