package com.elitescloud.boot.datasecurity.dpr.content;


import com.elitescloud.cloudt.system.vo.DprUdcVO;

import java.util.ArrayList;
import java.util.List;

/**
 * 规则字段类型
 *
 * @author chen**/
public enum DprRuleRelationEnum implements BasicUdcEnumInterface {
    DPR_RULE_RELATION_AND("SYSTEM", "DPR_RULE_RELATION", "规则关系", "且AND",1),
    DPR_RULE_RELATION_OR("SYSTEM", "DPR_RULE_RELATION", "规则关系", "或OR",2),
     ;

    /*** 应用编码*/
    private final String domainCode;
    /*** 枚举/udc的大类 */
    private final String udcCode;
    /*** 枚举.udc的大类名称*/
    private final String udcName;
    /*** 当前枚举值字符串的描述*/
    private final String valueDescription;
    /*** 排序*/
    private final int sortNo;
    private final DprUdcVO sysUdcVO;

    DprRuleRelationEnum(String domainCode, String udcCode,
                        String udcName, String description,
                        int sortNo
    ) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.valueDescription = description;
        this.sysUdcVO = this.newUdcVo(domainCode, udcCode, udcName, description, sortNo, this.name());
    }

    @Override
    public DprUdcVO getUdcVO() {
        return this.sysUdcVO;
    }

    @Override
    public String getValueDescription() {
        return valueDescription;
    }

    public static String getValue(String key) {
        for (var ele : values()) {
            if (ele.name().equals(key)) {
                return ele.getValueDescription();
            }
        }
        return null;
    }
    public static List<DprUdcVO> getSysUdcVOList() {
        ArrayList<DprUdcVO> sysUdcVOList = new ArrayList<>();
        for (var ele : values()) {
            sysUdcVOList.add(ele.getUdcVO());
        }
        return sysUdcVOList;
    }
}
