package com.elitescloud.boot.datasecurity.dpr.content;


import com.elitescloud.cloudt.system.vo.DprUdcVO;

import java.util.ArrayList;
import java.util.List;

/**
 * 规则值类型
 *
 * @author chen
 **/
public enum DprRuleValueTypeEnum implements BasicUdcEnumInterface {
    DPR_RULE_VALUE_TYPE_SYS("cloudt-system", "DPR_RULE_VALUE_TYPE", "规则值类型", "系统内置", 2),
//    DPR_RULE_VALUE_TYPE_FIXED("cloudt-system", "DPR_RULE_VALUE_TYPE", "规则值类型", "规则值固定", 4),
    DPR_RULE_VALUE_TYPE_CUSTOM("cloudt-system", "DPR_RULE_VALUE_TYPE", "规则值类型", "自定义", 3),
    DPR_RULE_VALUE_TYPE_BUSINESS("cloudt-system", "DPR_RULE_VALUE_TYPE", "规则值类型", "业务数据集", 1),
    ;

    /*** 应用编码*/
    private final String domainCode;
    /*** 枚举/udc的大类 */
    private final String udcCode;
    /*** 枚举.udc的大类名称*/
    private final String udcName;
    /*** 当前枚举值字符串的描述*/
    private final String valueDescription;
    /*** 排序*/
    private final int sortNo;
    private final DprUdcVO sysUdcVO;

    DprRuleValueTypeEnum(String domainCode, String udcCode,
                         String udcName, String description,
                         int sortNo
    ) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.valueDescription = description;
        this.sysUdcVO = this.newUdcVo(domainCode, udcCode, udcName, description, sortNo, this.name());
    }

    @Override
    public DprUdcVO getUdcVO() {
        return this.sysUdcVO;
    }

    @Override
    public String getValueDescription() {
        return valueDescription;
    }

    public static String getValue(String key) {
        for (var ele : values()) {
            if (ele.name().equals(key)) {
                return ele.getValueDescription();
            }
        }
        return null;
    }

    public static List<DprUdcVO> getSysUdcVOList() {
        ArrayList<DprUdcVO> sysUdcVOList = new ArrayList<>();
        for (var ele : values()) {
            sysUdcVOList.add(ele.getUdcVO());
        }
        return sysUdcVOList;
    }
}
