package com.elitescloud.boot.datasecurity.jpa.strategy;

import com.elitescloud.boot.datasecurity.common.DataSecurityUtil;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import lombok.extern.slf4j.Slf4j;

/**
 * 数据权限JPA应用的接口
 *
 * @author : chen.niu
 * @date : 2023/10/14 18:46
 * @deprecated 请使用 {@link com.elitescloud.boot.datasecurity.common.DataSecurityUtil}的jpa相关方法
 */
@Deprecated
@Slf4j
public class RoleRuleJpaService {
    /***
     * 返回当前用户的访问的API的菜单的角色权限的JPA Predicate条件
     * 如果菜单编码为空将会抛异常，强制要求前端传递过来。
     * @param entityClass jpa实体类
     * @param alias jpa sql查询表的别名，如果没有其就是jpa实体类的首字母小写名称 如SysUser 应该是sysUser
     * @deprecated 异常抛出无捕获，请使用{@link com.elitescloud.boot.datasecurity.common.DataSecurityUtil#predicateForJPA(Class)}
     * **/
    @Deprecated(since = "3.3.0")
    public Predicate getUserRoleApiMenusAuthJpaPredicate(Class<?> entityClass, String alias) {
        var predicate = DataSecurityUtil.predicateForJPA(entityClass, alias);
        log.info("数据权限过滤条件：{}", predicate);
        return predicate;
    }

    /***
     * 返回当前用户的访问的API的菜单的角色权限的JPA Predicate条件
     *  这个方法菜单编码可以为空，如果空跳过权限。主要用于不好判断是否一定前端请求的接口，有的接口可能前端数据权限调用或采用定时任务或MQ消费复用的情况。
     * @param entityClass jpa实体类
     * @param alias jpa sql查询表的别名，如果没有其就是jpa实体类的首字母小写名称 如SysUser 应该是sysUser
     * @deprecated 请使用 {@link DataSecurityUtil#predicateForJPA(Class, String, String...)}
     * **/
    @Deprecated(since = "3.3.0")
    public Predicate getUserRoleApiMenusAuthJpaPredicateMenusCodeEmpty(Class<?> entityClass, String alias) {
        try {
            return getUserRoleApiMenusAuthJpaPredicate(entityClass, alias);
        } catch (Exception e) {
            log.error("JPA权限异常，异常需要分析，暂跳过权限功能：" + entityClass.getSimpleName() + "-" + alias, e);
            return new BooleanBuilder(null);
        }
    }

    /***
     * 返回当前用户的访问的API的菜单的角色权限的JPA Predicate条件
     *  这个方法菜单编码可以为空，如果空跳过权限。主要用于不好判断是否一定前端请求的接口，有的接口可能前端数据权限调用或采用定时任务或MQ消费复用的情况。
     * jpa sql查询表的别名，如果没有其就是jpa实体类的首字母小写名称 如SysUser 应该是sysUser
     *
     * @param entityClass jpa实体类
     * @deprecated 请使用{@link com.elitescloud.boot.datasecurity.common.DataSecurityUtil#predicateForJPA(Class)}
     * **/
    @Deprecated(since = "3.3.0")
    public Predicate getUserRoleApiMenusAuthJpaPredicateMenusCodeEmpty(Class<?> entityClass) {
        String menuCode = "";
        try {
            //如果没有别名，使用JPA默认规范，DO Class名称，首字母小写。
            var classAlias = entityClass.getSimpleName().substring(0, 1).toLowerCase()
                    + entityClass.getSimpleName().substring(1);
            return getUserRoleApiMenusAuthJpaPredicate(entityClass, classAlias);
        } catch (Exception e) {
            log.error("JPA权限异常，异常需要分析，暂跳过权限功能：" + entityClass.getSimpleName() + "-" + menuCode + "-", e);
            return new BooleanBuilder(null);
        }
    }

    /***
     * 返回当前用户的访问的API的菜单的角色权限的JPA Predicate条件
     *  这个方法菜单编码可以为空，如果空跳过权限。主要用于不好判断是否一定前端请求的接口，有的接口可能前端数据权限调用或采用定时任务或MQ消费复用的情况。
     * jpa sql查询表的别名，如果没有其就是jpa实体类的首字母小写名称 如SysUser 应该是sysUser
     *
     * @param entityClass jpa实体类
     * @deprecated 请使用{@link com.elitescloud.boot.datasecurity.common.DataSecurityUtil#predicateForJPA(Class)}
     * **/
    @Deprecated(since = "3.3.0")
    public Predicate getUserRoleApiMenusAuthJpaPredicateMenusCodeEmpty(Class<?> entityClass, String alias, String... ruleFieldName) {
        String menuCode = "";
        try {
            return DataSecurityUtil.predicateForJPA(entityClass, alias, ruleFieldName);
        } catch (Exception e) {
            log.error("JPA权限异常，异常需要分析，暂跳过权限功能：" + entityClass.getSimpleName() + "-" + menuCode + "-", e);
            return new BooleanBuilder(null);
        }
    }
}