package com.elitescloud.boot.datasecurity.jpa.strategy;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.PathBuilder;

/**
 * @author : chen.niu
 * @description : 规则策略接口用于jpa queryDsl的不同策略规则实现
 * @date : 2023/10/14 16:54
 */
public interface RuleStrategy {
//    Predicate applyRule(PathBuilder<?> entityPath, String fieldName, String ruleValue,Class fieldType);
            /**
             * 应用规则接口
             * PathBuilder是EntityPathBase的扩展，用于动态路径构建
             * fieldName 规则字段名称
             * ruleValue 规则值
             *
             * 实现示例：
             *         NumberPath<Integer> path = entityPath.getNumber(fieldName, Integer.class);
             *         Integer value = Integer.valueOf(ruleValue);
             *         return path.eq(value);
             * **/
         Predicate applyRule(PathBuilder<?> entityPath, String fieldName, String ruleValue);

}
